/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common;

import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.ci.BuildRetention;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.hudson.AbstractBuildInfoDeployer;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;

public class BuildInfoDeployer
extends AbstractBuildInfoDeployer {
    private final Run build;
    private final Map<String, String> sysVars;
    private final Map<String, String> envVars;
    private ArtifactoryConfigurator configurator;
    private org.jfrog.build.extractor.ci.BuildInfo buildInfo;
    private boolean asyncBuildRetention;
    private final String platformUrl;

    public BuildInfoDeployer(ArtifactoryConfigurator configurator, ArtifactoryManager artifactoryManager, Run build, TaskListener listener, BuildInfo deployedBuildInfo, String platformUrl) throws IOException, InterruptedException {
        super(configurator, build, listener, artifactoryManager);
        this.configurator = configurator;
        this.build = build;
        this.platformUrl = platformUrl;
        this.envVars = deployedBuildInfo.getEnvVars();
        this.sysVars = deployedBuildInfo.getSysVars();
        this.buildInfo = this.createBuildInfo("Pipeline", "");
        this.buildInfo.setBuildRetention(deployedBuildInfo.getRetention().createBuildRetention());
        this.asyncBuildRetention = deployedBuildInfo.getRetention().isAsync();
        if (deployedBuildInfo.getStartDate() != null) {
            this.buildInfo.setStartedDate(deployedBuildInfo.getStartDate());
        }
        this.buildInfo.setModules(new ArrayList<Module>(deployedBuildInfo.getModules()));
        if (StringUtils.isNotEmpty((CharSequence)deployedBuildInfo.getName())) {
            this.buildInfo.setName(deployedBuildInfo.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)deployedBuildInfo.getNumber())) {
            this.buildInfo.setNumber(deployedBuildInfo.getNumber());
        }
        this.buildInfo.setProject(deployedBuildInfo.getProject());
        if (deployedBuildInfo.getIssues() != null && !deployedBuildInfo.getConvertedIssues().isEmpty()) {
            this.buildInfo.setIssues(deployedBuildInfo.getConvertedIssues());
        }
        this.addVcsDataToBuild(deployedBuildInfo);
    }

    private void addVcsDataToBuild(BuildInfo deployedBuildInfo) {
        if (CollectionUtils.isEmpty(deployedBuildInfo.getVcs())) {
            return;
        }
        List<Object> vcsList = deployedBuildInfo.getVcs();
        vcsList = vcsList.stream().distinct().collect(Collectors.toList());
        this.buildInfo.setVcs(vcsList);
    }

    public void deploy() throws IOException {
        String artifactoryUrl = this.configurator.getArtifactoryServer().getArtifactoryUrl();
        BuildRetention retention = this.buildInfo.getBuildRetention();
        this.buildInfo.setBuildRetention(null);
        Utils.sendBuildAndBuildRetention((ArtifactoryManager)this.artifactoryManager, (org.jfrog.build.extractor.ci.BuildInfo)this.buildInfo, (BuildRetention)retention, (boolean)this.asyncBuildRetention, (String)this.platformUrl);
        this.addBuildInfoResultAction(artifactoryUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildInfoResultAction(String artifactoryUrl) {
        List list = this.build.getAllActions();
        synchronized (list) {
            BuildInfoResultAction action = (BuildInfoResultAction)this.build.getAction(BuildInfoResultAction.class);
            if (action == null) {
                action = new BuildInfoResultAction(this.build);
                this.build.addAction((Action)action);
            }
            action.addBuildInfoResults(artifactoryUrl, this.platformUrl, this.buildInfo);
        }
    }

    @Override
    protected void addBuildInfoProperties(BuildInfoBuilder builder) {
        if (this.envVars != null) {
            for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
                builder.addProperty((Object)("buildInfo.env." + entry.getKey()), (Object)entry.getValue());
            }
        }
        if (this.sysVars != null) {
            for (Map.Entry<String, String> entry : this.sysVars.entrySet()) {
                builder.addProperty((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

