/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.types.DistributionRules;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.types.ReleaseNotes;
import org.jfrog.build.extractor.clientConfiguration.util.GitUtils;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.common.types.DistributionConfig;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.pipeline.common.types.XrayScanConfig;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.SerializationUtils;

public class Utils {
    public static final String CONAN_USER_HOME = "CONAN_USER_HOME";
    public static final String BUILD_INFO = "buildInfo";
    private static final String UNIX_SPECIAL_CHARS = "`^<>| ,;!?'\"()[]{}$*\\&#";

    public static FilePath extractRootWorkspace(StepContext context, WorkflowRun build, FilePath cwd) throws IOException, InterruptedException {
        FilePath flowWorkspace = Utils.extractRootWorkspaceFromFlow(build.getExecution());
        if (flowWorkspace != null) {
            return flowWorkspace;
        }
        Node node = (Node)context.get(Node.class);
        if (node == null) {
            return cwd;
        }
        FilePath ws = node.getWorkspaceFor((TopLevelItem)build.getParent());
        return (FilePath)ObjectUtils.defaultIfNull((Object)ws, (Object)cwd);
    }

    private static FilePath extractRootWorkspaceFromFlow(FlowExecution execution) {
        if (execution == null) {
            return null;
        }
        FlowGraphWalker flowWalker = new FlowGraphWalker(execution);
        FilePath rootPath = null;
        for (FlowNode node : flowWalker) {
            FilePath rootWorkspace;
            WorkspaceAction workspaceAction = (WorkspaceAction)node.getAction(WorkspaceAction.class);
            if (workspaceAction == null || (rootWorkspace = workspaceAction.getWorkspace()) == null) continue;
            rootPath = rootWorkspace;
        }
        return rootPath;
    }

    public static ArtifactoryServer prepareArtifactoryServer(String artifactoryServerID, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer) {
        if (artifactoryServerID == null && pipelineServer == null) {
            return null;
        }
        if (artifactoryServerID != null && pipelineServer != null) {
            return null;
        }
        if (pipelineServer != null) {
            CredentialsConfig credentials = pipelineServer.createCredentialsConfig();
            return new ArtifactoryServer(null, pipelineServer.getUrl(), credentials, credentials, pipelineServer.getConnection().getTimeout(), pipelineServer.isBypassProxy(), pipelineServer.getConnection().getRetry(), pipelineServer.getDeploymentThreads());
        }
        return RepositoriesUtils.getArtifactoryServer(artifactoryServerID);
    }

    public static BuildInfo prepareBuildinfo(Run build, BuildInfo buildinfo) {
        if (buildinfo == null) {
            return new BuildInfo(build);
        }
        return buildinfo;
    }

    public static EnvVars extractBuildParameters(Run build, TaskListener listener) {
        EnvVars buildVariables = new EnvVars();
        try {
            ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
            if (parameters != null) {
                for (ParameterValue p : parameters) {
                    String v;
                    if (p.isSensitive() || (v = (String)p.createVariableResolver(null).resolve(p.getName())) == null) continue;
                    buildVariables.put(p.getName(), v);
                }
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Can't get build variables");
            return null;
        }
        return buildVariables;
    }

    public static Vcs extractVcs(FilePath filePath, final Log log) throws IOException, InterruptedException {
        return (Vcs)filePath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Vcs>(){

            public Vcs invoke(File f, VirtualChannel channel) throws IOException {
                return GitUtils.extractVcs((File)f, (Log)log);
            }
        });
    }

    public static Computer getCurrentComputer(Launcher launcher) {
        Jenkins j = Jenkins.get();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != launcher.getChannel()) continue;
            return c;
        }
        return null;
    }

    public static IncludesExcludes getArtifactsIncludeExcludeForDeyployment(IncludeExcludePatterns patternFilter) {
        int i;
        if (patternFilter == null) {
            return new IncludesExcludes("", "");
        }
        String[] excludePatterns = patternFilter.getExcludePatterns();
        String[] includePatterns = patternFilter.getIncludePatterns();
        StringBuilder include = new StringBuilder();
        StringBuilder exclude = new StringBuilder();
        for (i = 0; i < includePatterns.length; ++i) {
            if (include.length() > 0) {
                include.append(", ");
            }
            include.append(includePatterns[i]);
        }
        for (i = 0; i < excludePatterns.length; ++i) {
            if (exclude.length() > 0) {
                exclude.append(", ");
            }
            exclude.append(excludePatterns[i]);
        }
        IncludesExcludes result = new IncludesExcludes(include.toString(), exclude.toString());
        return result;
    }

    public static org.jfrog.build.extractor.ci.BuildInfo getGeneratedBuildInfo(Run build, TaskListener listener, Launcher launcher, String jsonBuildPath) {
        org.jfrog.build.extractor.ci.BuildInfo buildInfo;
        FilePath generatedBuildInfoFilePath;
        block8: {
            String buildInfoFileContent;
            InputStream inputStream;
            ObjectMapper mapper;
            block6: {
                org.jfrog.build.extractor.ci.BuildInfo buildInfo2;
                block7: {
                    mapper = SerializationUtils.createMapper();
                    generatedBuildInfoFilePath = null;
                    inputStream = null;
                    StringWriter writer = new StringWriter();
                    generatedBuildInfoFilePath = new FilePath(launcher.getChannel(), jsonBuildPath);
                    inputStream = generatedBuildInfoFilePath.read();
                    IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
                    buildInfoFileContent = writer.toString();
                    if (!StringUtils.isBlank((CharSequence)buildInfoFileContent)) break block6;
                    buildInfo2 = new org.jfrog.build.extractor.ci.BuildInfo();
                    if (inputStream == null) break block7;
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                Utils.deleteFilePathQuietly(generatedBuildInfoFilePath);
                return buildInfo2;
            }
            try {
                buildInfo = (org.jfrog.build.extractor.ci.BuildInfo)mapper.readValue(buildInfoFileContent, org.jfrog.build.extractor.ci.BuildInfo.class);
                if (inputStream == null) break block8;
            }
            catch (Exception e) {
                try {
                    listener.error("Couldn't read generated build info at : " + jsonBuildPath);
                    throw new Run.RunnerAbortedException();
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        IOUtils.closeQuietly(inputStream);
                    }
                    Utils.deleteFilePathQuietly(generatedBuildInfoFilePath);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        Utils.deleteFilePathQuietly(generatedBuildInfoFilePath);
        return buildInfo;
    }

    private static void deleteFilePathQuietly(FilePath filePath) {
        try {
            if (filePath != null && filePath.exists()) {
                filePath.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String createTempJsonFile(Launcher launcher, final String name, final String dir) throws Exception {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, Exception>(){

            public String call() throws IOException {
                File tempFile = File.createTempFile(name, ".json", new File(dir));
                tempFile.deleteOnExit();
                return tempFile.getAbsolutePath();
            }
        });
    }

    public static void launch(String taskName, Launcher launcher, ArgumentListBuilder args, EnvVars env, TaskListener listener, FilePath ws) {
        boolean failed;
        try {
            int exitValue = launcher.launch().cmds(args).envs((Map)env).stdout(listener).stderr((OutputStream)listener.getLogger()).pwd(ws).join();
            failed = exitValue != 0;
        }
        catch (Exception e) {
            listener.error("Couldn't execute " + taskName + " task. " + ExceptionUtils.getMessage((Throwable)e));
            failed = true;
        }
        if (failed) {
            throw new RuntimeException(taskName + " build failed");
        }
    }

    public static String getJavaPathBuilder(String jdkBinPath, Launcher launcher) {
        StringBuilder javaPathBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)jdkBinPath)) {
            javaPathBuilder.append(jdkBinPath).append("/");
        }
        javaPathBuilder.append("java");
        if (!launcher.isUnix()) {
            javaPathBuilder.append(".exe");
        }
        return javaPathBuilder.toString();
    }

    public static String escapeUnixArgument(String arg) {
        StringBuilder res = new StringBuilder();
        for (char c : arg.toCharArray()) {
            if (UNIX_SPECIAL_CHARS.indexOf(c) >= 0) {
                res.append("\\");
            }
            res.append(c);
        }
        return res.toString();
    }

    public static PromotionConfig createPromotionConfig(Map<String, Object> promotionParams, boolean isTargetRepositoryMandatory) {
        String targetRepository = "targetRepo";
        ArrayList<String> mandatoryParams = new ArrayList<String>(Arrays.asList("buildName", "buildNumber"));
        List<String> allowedParams = Arrays.asList("buildName", "buildNumber", "project", "targetRepo", "sourceRepo", "status", "comment", "includeDependencies", "copy", "failFast");
        if (isTargetRepositoryMandatory) {
            mandatoryParams.add("targetRepo");
        }
        if (!promotionParams.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(((Object)mandatoryParams).toString() + " are mandatory arguments");
        }
        if (!allowedParams.containsAll(promotionParams.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + allowedParams.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        PromotionConfig config = (PromotionConfig)mapper.convertValue(promotionParams, PromotionConfig.class);
        return config;
    }

    public static org.jfrog.hudson.release.promotion.PromotionConfig convertPromotionConfig(PromotionConfig pipelinePromotionConfig) {
        org.jfrog.hudson.release.promotion.PromotionConfig promotionConfig = new org.jfrog.hudson.release.promotion.PromotionConfig();
        promotionConfig.setBuildName(pipelinePromotionConfig.getBuildName());
        promotionConfig.setBuildNumber(pipelinePromotionConfig.getBuildNumber());
        promotionConfig.setProject(pipelinePromotionConfig.getProject());
        promotionConfig.setTargetRepo(pipelinePromotionConfig.getTargetRepo());
        promotionConfig.setSourceRepo(pipelinePromotionConfig.getSourceRepo());
        promotionConfig.setStatus(pipelinePromotionConfig.getStatus());
        promotionConfig.setComment(pipelinePromotionConfig.getComment());
        promotionConfig.setIncludeDependencies(pipelinePromotionConfig.isIncludeDependencies());
        promotionConfig.setCopy(pipelinePromotionConfig.isCopy());
        promotionConfig.setFailFast(pipelinePromotionConfig.isFailFast());
        return promotionConfig;
    }

    public static DistributionConfig createDistributionConfig(Map<String, Object> promotionParams) {
        ArrayList<String> mandatoryParams = new ArrayList<String>(Arrays.asList("buildName", "buildNumber", "targetRepo"));
        List<String> allowedParams = Arrays.asList("buildName", "buildNumber", "publish", "overrideExistingFiles", "gpgPassphrase", "async", "targetRepo", "sourceRepos", "dryRun");
        if (!promotionParams.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(((Object)mandatoryParams).toString() + " are mandatory arguments");
        }
        if (!allowedParams.containsAll(promotionParams.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + allowedParams.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        DistributionConfig config = (DistributionConfig)mapper.convertValue(promotionParams, DistributionConfig.class);
        return config;
    }

    public static String getAgentName(FilePath ws) {
        if (ws.getChannel() != null) {
            return ws.getChannel() instanceof LocalChannel ? "Master" : ((Channel)ws.getChannel()).getName();
        }
        return "Unknown";
    }

    public static void appendBuildInfo(CpsScript cpsScript, Map<String, Object> stepVariables) {
        BuildInfo buildInfo = (BuildInfo)stepVariables.get(BUILD_INFO);
        if (buildInfo == null) {
            buildInfo = (BuildInfo)cpsScript.invokeMethod("newBuildInfo", new LinkedHashMap());
            stepVariables.put(BUILD_INFO, buildInfo);
        }
        buildInfo.setCpsScript(cpsScript);
    }

    public static ProxyConfiguration getProxyConfiguration(ArtifactoryServer server) {
        if (server.isBypassProxy()) {
            return null;
        }
        return ProxyUtils.createProxyConfiguration();
    }

    public static ArrayListMultimap<String, String> getPropertiesMap(BuildInfo buildInfo, Run build, StepContext context) throws IOException, InterruptedException {
        ArrayListMultimap properties = ArrayListMultimap.create();
        if (buildInfo.getName() != null) {
            properties.put((Object)"build.name", (Object)buildInfo.getName());
        } else {
            properties.put((Object)"build.name", (Object)BuildUniqueIdentifierHelper.getBuildName(build));
        }
        if (buildInfo.getNumber() != null) {
            properties.put((Object)"build.number", (Object)buildInfo.getNumber());
        } else {
            properties.put((Object)"build.number", (Object)BuildUniqueIdentifierHelper.getBuildNumber(build));
        }
        properties.put((Object)"build.timestamp", (Object)(build.getTimestamp().getTime().getTime() + ""));
        Utils.addParentBuildProps((ArrayListMultimap<String, String>)properties, build);
        EnvVars env = (EnvVars)context.get(EnvVars.class);
        Utils.addVcsDetailsToProps(env, (ArrayListMultimap<String, String>)properties);
        return properties;
    }

    public static void addParentBuildProps(ArrayListMultimap<String, String> properties, Run build) {
        Cause.UpstreamCause parent = ActionableHelper.getUpstreamCause(build);
        if (parent != null) {
            properties.put((Object)"build.parentName", (Object)ExtractorUtils.sanitizeBuildName(parent.getUpstreamProject()));
            properties.put((Object)"build.parentNumber", (Object)(parent.getUpstreamBuild() + ""));
        }
    }

    public static void addVcsDetailsToProps(EnvVars env, ArrayListMultimap<String, String> properties) {
        String gitMessage;
        String gitBranch;
        String gitUrl;
        String revision = ExtractorUtils.getVcsRevision((Map<String, String>)env);
        if (StringUtils.isNotBlank((CharSequence)revision)) {
            properties.put((Object)"vcs.revision", (Object)revision);
        }
        if (StringUtils.isNotBlank((CharSequence)(gitUrl = ExtractorUtils.getVcsUrl((Map<String, String>)env)))) {
            properties.put((Object)"vcs.url", (Object)gitUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(gitBranch = ExtractorUtils.getVcsBranch((Map<String, String>)env)))) {
            properties.put((Object)"vcs.branch", (Object)gitBranch);
        }
        if (StringUtils.isNotBlank((CharSequence)(gitMessage = ExtractorUtils.getVcsMessage((Map<String, String>)env)))) {
            properties.put((Object)"vcs.message", (Object)gitMessage);
        }
    }

    public static String replaceTildeWithUserHome(String path) {
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    public static void addNpmToPath(FilePath ws, TaskListener listener, EnvVars env, Launcher launcher, String nodeTool) throws IOException, InterruptedException {
        if (StringUtils.isNotEmpty((CharSequence)nodeTool)) {
            Utils.prependNpmToPathFromTool(ws, listener, env, launcher, nodeTool);
        } else {
            String nodejsHome = (String)env.get((Object)"NODEJS_HOME");
            if (nodejsHome != null) {
                Utils.prependNodeJSHomeToPath(env, ws.child(nodejsHome));
            }
        }
    }

    private static void prependNpmToPathFromTool(FilePath ws, TaskListener listener, EnvVars env, Launcher launcher, String nodeTool) throws IOException, InterruptedException {
        JenkinsBuildInfoLog logger = new JenkinsBuildInfoLog(listener);
        NodeJSInstallation nodeInstallation = Utils.getNpmInstallation(nodeTool);
        if (nodeInstallation == null) {
            logger.error("Couldn't find NodeJS tool '" + nodeTool + "'");
            throw new Run.RunnerAbortedException();
        }
        Node node = ActionableHelper.getNode(launcher);
        String nodeJsHome = nodeInstallation.forNode(node, listener).forEnvironment(env).getHome();
        if (StringUtils.isBlank((CharSequence)nodeJsHome)) {
            logger.error("Couldn't find NodeJS home");
            throw new Run.RunnerAbortedException();
        }
        Utils.prependNodeJSHomeToPath(env, ws.child(nodeJsHome));
    }

    private static void prependNodeJSHomeToPath(EnvVars env, FilePath nodeJsHome) {
        env.override("PATH+NODEJS", nodeJsHome.child("bin").getRemote());
        env.override("PATH+NODEJS", nodeJsHome.getRemote());
    }

    private static NodeJSInstallation getNpmInstallation(String nodeTool) {
        NodeJSInstallation[] installations = (NodeJSInstallation[])((NodeJSInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(NodeJSInstallation.DescriptorImpl.class)).getInstallations();
        return Arrays.stream(installations).filter(i -> nodeTool.equals(i.getName())).findFirst().orElse(null);
    }

    public static XrayScanConfig createXrayScanConfig(Map<String, Object> xrayScanParams) {
        String failBuild = "failBuild";
        String printTable = "printTable";
        List<String> mandatoryArgumentsAsList = Arrays.asList("buildName", "buildNumber");
        if (!xrayScanParams.keySet().containsAll(mandatoryArgumentsAsList)) {
            throw new IllegalArgumentException(mandatoryArgumentsAsList.toString() + " are mandatory arguments");
        }
        Set<String> xrayScanParamsSet = xrayScanParams.keySet();
        List<String> keysAsList = Arrays.asList("buildName", "buildNumber", "project", "failBuild", "printTable");
        if (!keysAsList.containsAll(xrayScanParamsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        return new XrayScanConfig((String)xrayScanParams.get("buildName"), (String)xrayScanParams.get("buildNumber"), (String)xrayScanParams.get("project"), (Boolean)xrayScanParams.get("failBuild"), (Boolean)xrayScanParams.get("printTable"));
    }

    public static FilePath createConanTempHome(FilePath ws) throws Exception {
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(ws);
        return tempDir.createTempDir("conan", "");
    }

    public static FilePath getConanHomeDirectory(String userPath, EnvVars env, Launcher launcher, FilePath ws) throws Exception {
        FilePath conanHomeDirectory = StringUtils.isEmpty((CharSequence)userPath) ? (env.containsKey((Object)CONAN_USER_HOME) ? new FilePath(launcher.getChannel(), (String)env.get((Object)CONAN_USER_HOME)) : Utils.createConanTempHome(ws)) : new FilePath(launcher.getChannel(), userPath);
        if (!conanHomeDirectory.exists()) {
            conanHomeDirectory.mkdirs();
        }
        conanHomeDirectory.child("conan_log.log").touch(Calendar.getInstance().getTimeInMillis());
        return conanHomeDirectory;
    }

    public static String buildConanRemoteUrl(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String repo) {
        StringBuilder serverURL = new StringBuilder(server.getUrl());
        if (!StringUtils.endsWith((CharSequence)serverURL.toString(), (CharSequence)"/")) {
            serverURL.append("/");
        }
        serverURL.append("api/conan/").append(repo);
        return serverURL.toString();
    }

    public static ReleaseNotes createReleaseNotes(String releaseNotesPath, String releaseNotesSyntax) throws IOException {
        if (StringUtils.isBlank((CharSequence)releaseNotesPath)) {
            return null;
        }
        String content = FileUtils.readFileToString((File)new File(releaseNotesPath), (String)StandardCharsets.UTF_8.name());
        ReleaseNotes releaseNotes = new ReleaseNotes();
        releaseNotes.setContent(content);
        releaseNotes.setSyntax(StringUtils.isBlank((CharSequence)releaseNotesSyntax) ? ReleaseNotes.Syntax.plain_text : ReleaseNotes.Syntax.valueOf((String)releaseNotesSyntax));
        return releaseNotes;
    }

    public static List<DistributionRules> createDistributionRules(List<String> countryCodes, String siteName, String cityName) throws IOException {
        DistributionRules distributionRules = new DistributionRules();
        distributionRules.setCountryCodes(countryCodes);
        distributionRules.setSiteName(siteName);
        distributionRules.setCityName(cityName);
        ArrayList<DistributionRules> distributionRulesList = new ArrayList<DistributionRules>();
        distributionRulesList.add(distributionRules);
        return distributionRulesList;
    }
}

