/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;

public class BuildAppendExecutor
implements Executor {
    private final org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer;
    private final TaskListener listener;
    private final BuildInfo buildInfo;
    private final String buildNumber;
    private final String buildName;
    private final Run<?, ?> build;

    public BuildAppendExecutor(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer, BuildInfo buildInfo, String buildName, String buildNumber, Run<?, ?> build, TaskListener listener) {
        this.pipelineServer = pipelineServer;
        this.buildNumber = buildNumber;
        this.buildName = buildName;
        this.buildInfo = buildInfo;
        this.listener = listener;
        this.build = build;
    }

    @Override
    public void execute() throws Exception {
        String project = this.buildInfo.getProject();
        String id = StringUtils.isNotBlank((CharSequence)project) ? this.buildInfo.getProject() + "/" + this.buildName + "/" + this.buildNumber : this.buildName + "/" + this.buildNumber;
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(id).type(ModuleType.BUILD);
        ArtifactoryServer server = Utils.prepareArtifactoryServer(null, this.pipelineServer);
        CredentialsConfig credentialsConfig = server.getResolverCredentialsConfig();
        Credentials credentials = credentialsConfig.provideCredentials((Item)this.build.getParent());
        long timestamp = this.getBuildTimestamp(server, credentials);
        this.addChecksumHeaders(server, credentials, moduleBuilder, timestamp);
        this.buildInfo.getModules().add(moduleBuilder.build());
    }

    private long getBuildTimestamp(ArtifactoryServer server, Credentials credentials) throws IOException, ParseException {
        try (ArtifactoryManager artifactoryManager = server.createArtifactoryManagerBuilder(credentials, ProxyUtils.createProxyConfiguration(), new JenkinsBuildInfoLog(this.listener)).build();){
            org.jfrog.build.extractor.ci.BuildInfo buildInfo = artifactoryManager.getBuildInfo(this.buildName, this.buildNumber, this.buildInfo.getProject());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            Date date = format.parse(buildInfo.getStarted());
            long l = date.getTime();
            return l;
        }
    }

    private void addChecksumHeaders(ArtifactoryServer server, Credentials credentials, ModuleBuilder moduleBuilder, long timestamp) throws IOException {
        String encodedBuildName = this.buildName.replaceAll(":", "%3A");
        String encodedBuildNumber = this.buildNumber.replaceAll(":", "%3A");
        String buildInfoRepo = StringUtils.isNotEmpty((CharSequence)this.buildInfo.getProject()) ? this.buildInfo.getProject() + "-build-info" : "artifactory-build-info";
        String buildInfoPath = buildInfoRepo + "/" + encodedBuildName + "/" + encodedBuildNumber + "-" + timestamp + ".json";
        try (ArtifactoryManager artifactoryManager = server.createArtifactoryManager(credentials, ProxyUtils.createProxyConfiguration(), this.listener);){
            block17: for (Header header : artifactoryManager.downloadHeaders(buildInfoPath)) {
                switch (header.getName()) {
                    case "X-Checksum-Sha1": {
                        moduleBuilder.sha1(header.getValue());
                        continue block17;
                    }
                    case "X-Checksum-Md5": {
                        moduleBuilder.md5(header.getValue());
                    }
                }
            }
        }
    }
}

