/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import antlr.ANTLRException;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.triggers.Trigger;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jfrog.build.api.util.Log;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.trigger.ArtifactoryTrigger;
import org.jfrog.hudson.trigger.ArtifactoryTriggerInfo;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class BuildTriggerExecutor
implements Executor {
    private final ArtifactoryServer server;
    private final Run<?, ?> build;
    private final String paths;
    private final String spec;
    private final Log logger;

    public BuildTriggerExecutor(Run<?, ?> build, TaskListener listener, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String paths, String spec) {
        this.server = Utils.prepareArtifactoryServer(null, server);
        this.server.setServerId(server.getServerName());
        this.logger = new JenkinsBuildInfoLog(listener);
        this.build = build;
        this.paths = paths;
        this.spec = spec;
    }

    @Override
    public void execute() throws IOException {
        WorkflowJob job = (WorkflowJob)this.build.getParent();
        try {
            this.logger.debug("Setting trigger for '" + this.server.getArtifactoryUrl() + "'. Paths: '" + this.paths + "' spec: '" + this.spec + "'");
            ArtifactoryTrigger artifactoryTrigger = new ArtifactoryTrigger(this.paths, this.spec);
            ServerDetails details = new ServerDetails(this.server.getServerId(), this.server.getArtifactoryUrl(), null, null, null, null);
            artifactoryTrigger.setDetails(details);
            if (details.getArtifactoryName() == null) {
                this.build.getParent().addOrReplaceAction((Action)new ArtifactoryTriggerInfo(this.server));
            }
            job.addTrigger((Trigger)artifactoryTrigger);
        }
        catch (ANTLRException e) {
            throw new IOException(e);
        }
    }
}

