/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.pipeline.common.executors.BuildInfoProcessRunner;
import org.jfrog.hudson.pipeline.common.executors.CreateDockerBuildEnvExtractor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.CommonDeployer;
import org.jfrog.hudson.util.ExtractorUtils;

public class CreateDockerBuildExecutor
extends BuildInfoProcessRunner {
    private final ArtifactoryServer server;
    private final String kanikoImageFile;
    private final String jibImageFile;
    private final String sourceRepo;

    public CreateDockerBuildExecutor(ArtifactoryServer pipelineServer, BuildInfo buildInfo, Run<?, ?> build, String kanikoImageFile, String jibImageFile, String sourceRepo, String javaArgs, Launcher launcher, TaskListener listener, FilePath ws, EnvVars envVars) {
        super(buildInfo, launcher, javaArgs, ws, "", "", envVars, listener, build);
        this.kanikoImageFile = kanikoImageFile;
        this.jibImageFile = jibImageFile;
        this.sourceRepo = sourceRepo;
        this.server = pipelineServer;
    }

    @Override
    public void execute() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Artifactory server must be configured");
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.kanikoImageFile, this.jibImageFile}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.kanikoImageFile, this.jibImageFile})) {
            throw new IllegalStateException("Exactly one of 'kanikoImageFile' or 'jibImageFile' must be configured");
        }
        CommonDeployer deployer = new CommonDeployer();
        deployer.setServer(this.server);
        deployer.setRepo(this.sourceRepo);
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        CreateDockerBuildEnvExtractor envExtractor = new CreateDockerBuildEnvExtractor(this.build, this.buildInfo, deployer, this.listener, this.launcher, tempDir, this.env, this.kanikoImageFile, this.jibImageFile);
        super.execute("Create Docker Build", "org.jfrog.build.extractor.docker.extractor.BuildDockerCreator", envExtractor, tempDir);
    }

    @Override
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }
}

