/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.model.Item;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.util.RepositoriesUtils;

public class GetJFrogPlatformInstancesExecutor
implements Executor {
    private final String jfrogInstancesID;
    private final Run<?, ?> build;
    private org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance jfrogPlatformInstance;

    public GetJFrogPlatformInstancesExecutor(Run<?, ?> build, String jfrogInstancesID) {
        this.jfrogInstancesID = jfrogInstancesID;
        this.build = build;
    }

    public org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance getJFrogPlatformInstance() {
        return this.jfrogPlatformInstance;
    }

    @Override
    public void execute() {
        if (StringUtils.isEmpty((CharSequence)this.jfrogInstancesID)) {
            throw new ServerNotFoundException("JFrog Instance ID is mandatory");
        }
        ArrayList<JFrogPlatformInstance> jfrogInstancesFound = new ArrayList<JFrogPlatformInstance>();
        List<JFrogPlatformInstance> jfrogInstances = RepositoriesUtils.getJFrogPlatformInstances();
        if (jfrogInstances == null) {
            throw new ServerNotFoundException("No JFrog Instances were configured");
        }
        for (JFrogPlatformInstance instance : jfrogInstances) {
            if (!instance.getId().equals(this.jfrogInstancesID)) continue;
            jfrogInstancesFound.add(instance);
        }
        if (jfrogInstancesFound.isEmpty()) {
            throw new ServerNotFoundException("Couldn't find JFrog Instance ID: " + this.jfrogInstancesID);
        }
        if (jfrogInstancesFound.size() > 1) {
            throw new ServerNotFoundException("Duplicate configured JFrog instance ID: " + this.jfrogInstancesID);
        }
        JFrogPlatformInstance jfrogPlatformInstance = (JFrogPlatformInstance)jfrogInstancesFound.get(0);
        DistributionServer distributionServer = new DistributionServer(jfrogPlatformInstance, (Item)this.build.getParent());
        ArtifactoryServer artifactoryServer = new ArtifactoryServer(jfrogPlatformInstance.getArtifactory(), (Item)this.build.getParent());
        this.jfrogPlatformInstance = new org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance(artifactoryServer, distributionServer, jfrogPlatformInstance.getUrl(), jfrogPlatformInstance.getId());
        artifactoryServer.setPlatformUrl(this.jfrogPlatformInstance.getUrl());
    }

    public static class ServerNotFoundException
    extends RuntimeException {
        public ServerNotFoundException(String message) {
            super(message);
        }
    }
}

