/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jfrog.build.api.util.Log;
import org.jfrog.hudson.pipeline.common.executors.BuildInfoProcessRunner;
import org.jfrog.hudson.pipeline.common.executors.NugetEnvExtractor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.NugetBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class NugetRunExecutor
extends BuildInfoProcessRunner {
    private NugetBuild nugetBuild;
    private String nugetArgs;
    private Log logger;

    public NugetRunExecutor(BuildInfo buildInfo, Launcher launcher, NugetBuild nugetBuild, String javaArgs, String nugetArgs, FilePath ws, String module, EnvVars env, TaskListener listener, Run build) {
        super(buildInfo, launcher, javaArgs, ws, "", module, env, listener, build);
        this.nugetBuild = nugetBuild;
        this.nugetArgs = nugetArgs;
        this.logger = new JenkinsBuildInfoLog(listener);
    }

    @Override
    public void execute() throws Exception {
        CommonResolver resolver = (CommonResolver)this.nugetBuild.getResolver();
        if (resolver.isEmpty()) {
            throw new IllegalStateException("Resolver must be configured with resolution repository and Artifactory server");
        }
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        NugetEnvExtractor envExtractor = new NugetEnvExtractor(this.build, this.buildInfo, resolver, this.listener, this.launcher, tempDir, this.env, this.nugetArgs, this.module, this.nugetBuild.useDotnetCli(), this.nugetBuild.getApiProtocol());
        super.execute("nuget", "org.jfrog.build.extractor.nuget.extractor.NugetRun", envExtractor, tempDir);
    }
}

