/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.hudson.pipeline.common.executors.BuildInfoProcessRunner;
import org.jfrog.hudson.pipeline.common.executors.PipEnvExtractor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PipBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class PipInstallExecutor
extends BuildInfoProcessRunner {
    PipBuild pipBuild;
    String pipArgs;
    String envActivation;
    Log logger;

    public PipInstallExecutor(BuildInfo buildInfo, Launcher launcher, PipBuild pipBuild, String javaArgs, String pipArgs, FilePath ws, String envActivation, String module, EnvVars env, TaskListener listener, Run build) {
        super(buildInfo, launcher, javaArgs, ws, null, module, env, listener, build);
        this.pipBuild = pipBuild;
        this.pipArgs = pipArgs;
        this.envActivation = envActivation;
        this.logger = new JenkinsBuildInfoLog(listener);
    }

    @Override
    public void execute() throws Exception {
        CommonResolver resolver = (CommonResolver)this.pipBuild.getResolver();
        if (resolver.isEmpty()) {
            throw new IllegalStateException("Resolver must be configured with resolution repository and Artifactory server");
        }
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        this.module = StringUtils.isNotBlank((CharSequence)this.module) ? this.module : this.buildInfo.getName();
        PipEnvExtractor envExtractor = new PipEnvExtractor(this.build, this.buildInfo, resolver, this.listener, this.launcher, tempDir, this.env, this.pipArgs, this.path, this.envActivation, this.module);
        super.execute("pip", "org.jfrog.build.extractor.pip.extractor.PipInstall", envExtractor, tempDir);
    }
}

