/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.extractor.buildScanTable.BuildScanTableHelper;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.XrayScanResultAction;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.XrayScanConfig;
import org.jfrog.hudson.pipeline.common.types.XrayScanResult;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class XrayExecutor
implements Executor {
    private final XrayScanConfig xrayScanConfig;
    private final ArtifactoryServer server;
    private final TaskListener listener;
    private final Run<?, ?> build;
    private XrayScanResult xrayScanResult;

    public XrayExecutor(XrayScanConfig xrayScanConfig, TaskListener listener, ArtifactoryServer server, Run<?, ?> build) {
        this.xrayScanConfig = xrayScanConfig;
        this.listener = listener;
        this.server = server;
        this.build = build;
    }

    @Override
    public void execute() throws Exception {
        JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
        Credentials credentials = this.server.createCredentialsConfig().provideCredentials((Item)this.build.getParent());
        ArtifactoryManager artifactoryManager = new ArtifactoryManager(this.server.getUrl(), credentials.getUsername(), credentials.getPassword(), credentials.getAccessToken(), (Log)log);
        ProxyConfiguration proxyConfiguration = Utils.getProxyConfiguration(Utils.prepareArtifactoryServer(null, this.server));
        if (proxyConfiguration != null) {
            artifactoryManager.setProxyConfiguration(proxyConfiguration);
        }
        ArtifactoryXrayResponse buildScanResult = artifactoryManager.scanBuild(this.xrayScanConfig.getBuildName(), this.xrayScanConfig.getBuildNumber(), this.xrayScanConfig.getProject(), "jenkins");
        this.xrayScanResult = new XrayScanResult(buildScanResult);
        if (this.xrayScanResult.isFoundVulnerable()) {
            this.addXrayResultAction(this.xrayScanResult.getScanUrl(), this.xrayScanConfig.getBuildName(), this.xrayScanConfig.getBuildNumber());
            if (this.xrayScanConfig.getPrintTable()) {
                new BuildScanTableHelper().printTable(buildScanResult, (Log)log);
            }
            if (this.xrayScanConfig.getFailBuild()) {
                throw new XrayScanException(this.xrayScanResult);
            }
            log.error(this.xrayScanResult.getScanMessage());
        } else {
            log.info(this.xrayScanResult.getScanMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.xrayScanResult.getScanUrl())) {
            log.info("Xray scan details are available at: " + this.xrayScanResult.getScanUrl());
        }
    }

    public XrayScanResult getXrayScanResult() {
        return this.xrayScanResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXrayResultAction(String xrayUrl, String buildName, String buildNumber) {
        String encodedXrayUrl = this.encodeXrayUrl(xrayUrl, buildName, buildNumber);
        Run<?, ?> run = this.build;
        synchronized (run) {
            XrayScanResultAction action = new XrayScanResultAction(encodedXrayUrl, this.build);
            this.build.addAction((Action)action);
        }
    }

    private String encodeXrayUrl(String xrayUrl, String buildName, String buildNumber) {
        return StringUtils.replaceOnce((String)xrayUrl, (String)(buildName + "/" + buildNumber), (String)(Util.rawEncode((String)buildName) + "/" + Util.rawEncode((String)buildNumber)));
    }

    public static class XrayScanException
    extends Exception {
        XrayScanException(XrayScanResult xrayScanResult) {
            super("Violations were found by Xray: " + xrayScanResult, null, true, false);
        }

        @Override
        public String toString() {
            return this.getLocalizedMessage();
        }
    }
}

