/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import hudson.model.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.Connection;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.plugins.PluginsUtils;

public class ArtifactoryServer
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String SPEC = "spec";
    public static final String PATHS = "paths";
    public static final String SERVER = "server";
    public static final String BUILD_NAME = "buildName";
    public static final String BUILD_NUMBER = "buildNumber";
    public static final String PROJECT = "project";
    public static final String FAIL_NO_OP = "failNoOp";
    public static final String MODULE = "module";
    public static final String PROPERTIES = "props";
    public static final String EDIT_PROPERTIES_TYPE = "editType";
    private String serverName;
    private String url;
    private String platformUrl;
    private String username;
    private String password;
    private String credentialsId;
    private boolean bypassProxy;
    private transient CpsScript cpsScript;
    private boolean usesCredentialsId;
    private final Connection connection = new Connection();
    private int deploymentThreads;

    public ArtifactoryServer() {
    }

    public ArtifactoryServer(String artifactoryServerName, String url, int deploymentThreads) {
        this.serverName = artifactoryServerName;
        this.url = url;
        this.deploymentThreads = deploymentThreads;
    }

    public ArtifactoryServer(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public ArtifactoryServer(String url, String credentialsId) {
        this.url = url;
        this.credentialsId = credentialsId;
        this.usesCredentialsId = true;
    }

    public ArtifactoryServer(org.jfrog.hudson.ArtifactoryServer jenkinsArtifactoryServer, Item parent) {
        this.serverName = jenkinsArtifactoryServer.getServerId();
        this.url = jenkinsArtifactoryServer.getArtifactoryUrl();
        this.deploymentThreads = jenkinsArtifactoryServer.getDeploymentThreads();
        if (PluginsUtils.isCredentialsPluginEnabled()) {
            this.credentialsId = jenkinsArtifactoryServer.getResolvingCredentialsConfig().getCredentialsId();
        } else {
            Credentials serverCredentials = jenkinsArtifactoryServer.getResolvingCredentialsConfig().provideCredentials(parent);
            this.username = serverCredentials.getUsername();
            this.password = serverCredentials.getPassword();
        }
        this.bypassProxy = jenkinsArtifactoryServer.isBypassProxy();
        this.connection.setRetry(jenkinsArtifactoryServer.getConnectionRetry());
        this.connection.setTimeout(jenkinsArtifactoryServer.getTimeout());
    }

    public CredentialsConfig createCredentialsConfig() {
        CredentialsConfig credentialsConfig = new CredentialsConfig(this.username, this.password, this.credentialsId, null);
        credentialsConfig.setIgnoreCredentialPluginDisabled(this.usesCredentialsId);
        return credentialsConfig;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    private Map<String, Object> getDownloadUploadObjectMap(Map<String, Object> arguments) {
        if (!arguments.containsKey(SPEC)) {
            throw new IllegalArgumentException("spec is a mandatory argument");
        }
        List<String> keysAsList = Arrays.asList(SPEC, "buildInfo", FAIL_NO_OP, MODULE);
        if (!keysAsList.containsAll(arguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed, " + keysAsList.toString());
        }
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>(arguments);
        stepVariables.put(SERVER, this);
        return stepVariables;
    }

    @Whitelisted
    public void download(Map<String, Object> downloadArguments) {
        Map<String, Object> stepVariables = this.getDownloadUploadObjectMap(downloadArguments);
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryDownload", stepVariables);
    }

    @Whitelisted
    public void download(String spec) {
        this.download(spec, null, false);
    }

    @Whitelisted
    public void download(String spec, BuildInfo buildInfo) {
        this.download(spec, buildInfo, false);
    }

    @Whitelisted
    public void download(String spec, boolean failNoOp) {
        this.download(spec, null, failNoOp);
    }

    @Whitelisted
    public void download(String spec, BuildInfo buildInfo, boolean failNoOp) {
        LinkedHashMap<String, Object> downloadArguments = new LinkedHashMap<String, Object>();
        downloadArguments.put(SPEC, spec);
        downloadArguments.put("buildInfo", buildInfo);
        downloadArguments.put(FAIL_NO_OP, failNoOp);
        this.download(downloadArguments);
    }

    @Whitelisted
    public void upload(Map<String, Object> uploadArguments) {
        Map<String, Object> stepVariables = this.getDownloadUploadObjectMap(uploadArguments);
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("artifactoryUpload", stepVariables);
    }

    @Whitelisted
    public void upload(String spec) {
        this.upload(spec, null, false);
    }

    @Whitelisted
    public void upload(String spec, BuildInfo buildInfo) {
        this.upload(spec, buildInfo, false);
    }

    @Whitelisted
    public void upload(String spec, boolean failNoOp) {
        this.upload(spec, null, failNoOp);
    }

    @Whitelisted
    public void upload(String spec, BuildInfo buildInfo, boolean failNoOp) {
        LinkedHashMap<String, Object> uploadArguments = new LinkedHashMap<String, Object>();
        uploadArguments.put(SPEC, spec);
        uploadArguments.put("buildInfo", buildInfo);
        uploadArguments.put(FAIL_NO_OP, failNoOp);
        this.upload(uploadArguments);
    }

    private Map<String, Object> getPropsObjectMap(Map<String, Object> arguments) {
        if (!arguments.containsKey(SPEC) || !arguments.containsKey(PROPERTIES)) {
            throw new IllegalArgumentException("specprops are mandatory arguments");
        }
        List<String> keysAsList = Arrays.asList(SPEC, PROPERTIES, FAIL_NO_OP);
        if (!keysAsList.containsAll(arguments.keySet())) {
            throw new IllegalArgumentException("Only the following arguments are allowed, " + keysAsList.toString());
        }
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>(arguments);
        stepVariables.put(SERVER, this);
        return stepVariables;
    }

    @Whitelisted
    public void setProps(Map<String, Object> propsArguments) {
        Map<String, Object> stepVariables = this.getPropsObjectMap(propsArguments);
        stepVariables.put(EDIT_PROPERTIES_TYPE, EditPropertiesHelper.EditPropertiesActionType.SET);
        this.cpsScript.invokeMethod("artifactoryEditProps", stepVariables);
    }

    @Whitelisted
    public void setProps(String spec, String props) {
        this.setProps(spec, props, false);
    }

    @Whitelisted
    public void setProps(String spec, String props, boolean failNoOp) {
        LinkedHashMap<String, Object> propsArguments = new LinkedHashMap<String, Object>();
        propsArguments.put(SPEC, spec);
        propsArguments.put(PROPERTIES, props);
        propsArguments.put(FAIL_NO_OP, failNoOp);
        this.setProps(propsArguments);
    }

    @Whitelisted
    public void deleteProps(Map<String, Object> propsArguments) {
        Map<String, Object> stepVariables = this.getPropsObjectMap(propsArguments);
        stepVariables.put(EDIT_PROPERTIES_TYPE, EditPropertiesHelper.EditPropertiesActionType.DELETE);
        this.cpsScript.invokeMethod("artifactoryEditProps", stepVariables);
    }

    @Whitelisted
    public void deleteProps(String spec, String props) {
        this.deleteProps(spec, props, false);
    }

    @Whitelisted
    public void deleteProps(String spec, String props, boolean failNoOp) {
        LinkedHashMap<String, Object> propsArguments = new LinkedHashMap<String, Object>();
        propsArguments.put(SPEC, spec);
        propsArguments.put(PROPERTIES, props);
        propsArguments.put(FAIL_NO_OP, failNoOp);
        this.deleteProps(propsArguments);
    }

    @Whitelisted
    public void publishBuildInfo(BuildInfo buildInfo) {
        LinkedHashMap<String, Serializable> stepVariables = new LinkedHashMap<String, Serializable>();
        stepVariables.put("buildInfo", buildInfo);
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("publishBuildInfo", stepVariables);
    }

    @Whitelisted
    public void buildAppend(BuildInfo buildInfo, String buildName, String buildNumber) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put("buildInfo", buildInfo);
        stepVariables.put(BUILD_NAME, buildName);
        stepVariables.put(BUILD_NUMBER, buildNumber);
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("buildAppend", stepVariables);
    }

    @Whitelisted
    public void promote(Map<String, Object> promotionParams) {
        LinkedHashMap<String, Serializable> stepVariables = new LinkedHashMap<String, Serializable>();
        stepVariables.put("promotionConfig", Utils.createPromotionConfig(promotionParams, true));
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("artifactoryPromoteBuild", stepVariables);
    }

    @Whitelisted
    public void distribute(Map<String, Object> distributionParams) {
        LinkedHashMap<String, Serializable> stepVariables = new LinkedHashMap<String, Serializable>();
        stepVariables.put("distributionConfig", Utils.createDistributionConfig(distributionParams));
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("artifactoryDistributeBuild", stepVariables);
    }

    @Whitelisted
    public void xrayScan(Map<String, Object> xrayScanParams) {
        LinkedHashMap<String, Serializable> stepVariables = new LinkedHashMap<String, Serializable>();
        stepVariables.put("xrayScanConfig", Utils.createXrayScanConfig(xrayScanParams));
        stepVariables.put(SERVER, this);
        this.cpsScript.invokeMethod("xrayScanBuild", stepVariables);
    }

    @Whitelisted
    public void setBuildTrigger(Map<String, Object> arguments) {
        ArrayList<String> mandatoryParams = new ArrayList<String>(Arrays.asList(PATHS, SPEC));
        if (!arguments.keySet().containsAll(mandatoryParams)) {
            throw new IllegalArgumentException(((Object)mandatoryParams).toString() + " are mandatory arguments");
        }
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put(SERVER, this);
        stepVariables.put(PATHS, arguments.get(PATHS));
        stepVariables.put(SPEC, arguments.get(SPEC));
        this.cpsScript.invokeMethod("artifactoryBuildTrigger", stepVariables);
    }

    public String getServerName() {
        return this.serverName;
    }

    @Whitelisted
    public String getUrl() {
        return this.url;
    }

    @Whitelisted
    public void setUrl(String url) {
        this.url = url;
    }

    @Whitelisted
    public String getUsername() {
        return this.username;
    }

    @Whitelisted
    public void setUsername(String username) {
        this.username = username;
        this.credentialsId = "";
        this.usesCredentialsId = false;
    }

    @Whitelisted
    public void setPassword(String password) {
        this.password = password;
        this.credentialsId = "";
        this.usesCredentialsId = false;
    }

    public String getPassword() {
        return this.password;
    }

    @Whitelisted
    public void setBypassProxy(boolean bypassProxy) {
        this.bypassProxy = bypassProxy;
    }

    @Whitelisted
    public boolean isBypassProxy() {
        return this.bypassProxy;
    }

    @Whitelisted
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Whitelisted
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
        this.password = "";
        this.username = "";
        this.usesCredentialsId = true;
    }

    @Whitelisted
    public Connection getConnection() {
        return this.connection;
    }

    @Whitelisted
    public int getDeploymentThreads() {
        return this.deploymentThreads;
    }

    @Whitelisted
    public void setDeploymentThreads(int deploymentThreads) {
        this.deploymentThreads = deploymentThreads;
    }

    public String getPlatformUrl() {
        return this.platformUrl;
    }

    public void setPlatformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
    }
}

