/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;

public class Docker
implements Serializable {
    private transient CpsScript cpsScript;
    private String host;
    private String javaArgs;
    private ArrayListMultimap<String, String> properties = ArrayListMultimap.create();
    private ArtifactoryServer server;

    public Docker() {
    }

    public Docker(CpsScript script, String host, String javaArgs) {
        this.cpsScript = script;
        this.host = host;
        this.javaArgs = javaArgs;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public void setServer(ArtifactoryServer server) {
        this.server = server;
    }

    @Whitelisted
    public Docker addProperty(String key, String ... values) {
        this.properties.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    @Whitelisted
    public void push(String imageTag, String targetRepo) {
        this.push(imageTag, targetRepo, null);
    }

    @Whitelisted
    public void push(String imageTag, String targetRepo, BuildInfo providedBuildInfo) {
        LinkedHashMap<String, Object> dockerArguments = new LinkedHashMap<String, Object>();
        dockerArguments.put("image", imageTag);
        dockerArguments.put("targetRepo", targetRepo);
        dockerArguments.put("buildInfo", providedBuildInfo);
        this.push(dockerArguments);
    }

    @Whitelisted
    public void push(Map<String, Object> dockerArguments) {
        dockerArguments.put("host", this.host);
        dockerArguments.put("properties", this.properties);
        dockerArguments.put("server", this.server);
        dockerArguments.put("javaArgs", this.javaArgs);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        this.cpsScript.invokeMethod("dockerPushStep", dockerArguments);
    }

    @Whitelisted
    public void pull(String imageTag, String sourceRepo) {
        this.pull(imageTag, sourceRepo, null);
    }

    @Whitelisted
    public void pull(String imageTag, String sourceRepo, BuildInfo providedBuildInfo) {
        LinkedHashMap<String, Object> dockerArguments = new LinkedHashMap<String, Object>();
        dockerArguments.put("image", imageTag);
        dockerArguments.put("sourceRepo", sourceRepo);
        dockerArguments.put("buildInfo", providedBuildInfo);
        this.pull(dockerArguments);
    }

    @Whitelisted
    public void pull(Map<String, Object> dockerArguments) {
        dockerArguments.put("host", this.host);
        dockerArguments.put("server", this.server);
        dockerArguments.put("javaArgs", this.javaArgs);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        this.cpsScript.invokeMethod("dockerPullStep", dockerArguments);
    }

    @Whitelisted
    public void createDockerBuild(String sourceRepo, String kanikoImageFile, String jibImageFiles) {
        this.createDockerBuild(sourceRepo, kanikoImageFile, jibImageFiles, null);
    }

    @Whitelisted
    public void createDockerBuild(String sourceRepo, String kanikoImageFile, String jibImageFiles, BuildInfo providedBuildInfo) {
        LinkedHashMap<String, Object> dockerArguments = new LinkedHashMap<String, Object>();
        dockerArguments.put("kanikoImageFile", kanikoImageFile);
        dockerArguments.put("jibImageFiles", jibImageFiles);
        dockerArguments.put("sourceRepo", sourceRepo);
        dockerArguments.put("buildInfo", providedBuildInfo);
        this.createDockerBuild(dockerArguments);
    }

    @Whitelisted
    public void createDockerBuild(Map<String, Object> dockerArguments) {
        dockerArguments.put("server", this.server);
        dockerArguments.put("javaArgs", this.javaArgs);
        Utils.appendBuildInfo(this.cpsScript, dockerArguments);
        this.cpsScript.invokeMethod("createDockerBuildStep", dockerArguments);
    }
}

