/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.buildInfo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.client.DeployableArtifactDetail;
import org.jfrog.build.extractor.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BaseBuildFileBean;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployableArtifactsUtils;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.BuildInfoDeployer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildRetention;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Env;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Issues;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

public class BuildInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String name;
    private String number;
    private String project;
    private Date startDate;
    private BuildRetention retention;
    private Map<String, List<DeployDetails>> deployableArtifactsByModule = new ConcurrentHashMap<String, List<DeployDetails>>();
    private List<Vcs> vcs = new ArrayList<Vcs>();
    private List<Module> modules = new CopyOnWriteArrayList<Module>();
    private Env env = new Env();
    private Issues issues = new Issues();
    private String agentName;

    public BuildInfo() {
        this.startDate = Calendar.getInstance().getTime();
        this.retention = new BuildRetention();
    }

    public BuildInfo(Run build) {
        this();
        this.name = BuildUniqueIdentifierHelper.getBuildName(build);
        this.number = BuildUniqueIdentifierHelper.getBuildNumber(build);
        this.issues.setBuildName(this.name);
    }

    @Whitelisted
    public void setName(String name) {
        this.name = name;
        this.issues.setBuildName(name);
    }

    @Whitelisted
    public void setNumber(String number) {
        this.number = number;
    }

    @Whitelisted
    public void setProject(String project) {
        this.project = project;
        this.issues.setProject(project);
    }

    @Whitelisted
    public String getName() {
        return this.name;
    }

    @Whitelisted
    public String getNumber() {
        return this.number;
    }

    @Whitelisted
    public String getProject() {
        return this.project;
    }

    @Whitelisted
    public Date getStartDate() {
        return this.startDate;
    }

    @Whitelisted
    public void setStartDate(Date date) {
        this.startDate = date;
    }

    @Whitelisted
    public List<org.jfrog.hudson.pipeline.types.File> getArtifacts() {
        Stream dependencyStream = this.modules.parallelStream().map(Module::getArtifacts).filter(Objects::nonNull).flatMap(Collection::stream);
        return this.getBuildFilesList(dependencyStream);
    }

    @Whitelisted
    public List<org.jfrog.hudson.pipeline.types.File> getDependencies() {
        Stream dependencyStream = this.modules.parallelStream().map(Module::getDependencies).filter(Objects::nonNull).flatMap(Collection::stream);
        return this.getBuildFilesList(dependencyStream);
    }

    private List<org.jfrog.hudson.pipeline.types.File> getBuildFilesList(Stream<? extends BaseBuildFileBean> buildFilesStream) {
        return buildFilesStream.filter(buildFile -> StringUtils.isNotBlank((CharSequence)buildFile.getLocalPath())).filter(buildFile -> StringUtils.isNotBlank((CharSequence)buildFile.getRemotePath())).map(org.jfrog.hudson.pipeline.types.File::new).distinct().collect(Collectors.toList());
    }

    @Whitelisted
    public void append(BuildInfo other) {
        this.appendDeployableArtifactsByModule(other.deployableArtifactsByModule);
        this.append(other.convertToBuild());
    }

    public void append(org.jfrog.build.extractor.ci.BuildInfo other) {
        org.jfrog.build.extractor.ci.BuildInfo appendedBuild = this.convertToBuild();
        appendedBuild.append(other);
        this.setModules(appendedBuild.getModules());
        Issues appendedIssues = Issues.toPipelineIssues(appendedBuild.getIssues());
        appendedIssues.setBuildName(this.getIssues().getBuildName());
        appendedIssues.setCpsScript(this.getIssues().getCpsScript());
        this.setIssues(appendedIssues);
        Properties properties = appendedBuild.getProperties();
        HashMap<String, String> appendedEnvVar = new HashMap<String, String>();
        HashMap<String, String> appendedSysVar = new HashMap<String, String>();
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                boolean isEnvVar = StringUtils.startsWith((CharSequence)key, (CharSequence)"buildInfo.env.");
                if (isEnvVar) {
                    appendedEnvVar.put(StringUtils.substringAfter((String)key, (String)"buildInfo.env."), properties.getProperty(key));
                    continue;
                }
                appendedSysVar.put(key, properties.getProperty(key));
            }
            this.getEnv().setEnvVars(appendedEnvVar);
            this.getEnv().setSysVars(appendedSysVar);
        }
    }

    @Whitelisted
    public Env getEnv() {
        return this.env;
    }

    @Whitelisted
    public Issues getIssues() {
        return this.issues;
    }

    @Whitelisted
    public BuildRetention getRetention() {
        return this.retention;
    }

    @Whitelisted
    public void retention(Map<String, Object> retentionArguments) {
        Set<String> retentionArgumentsSet = retentionArguments.keySet();
        List<String> keysAsList = Arrays.asList("maxDays", "maxBuilds", "deleteBuildArtifacts", "doNotDiscardBuilds", "async");
        if (!keysAsList.containsAll(retentionArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        this.retention = (BuildRetention)mapper.convertValue(retentionArguments, BuildRetention.class);
    }

    public Map<String, List<DeployDetails>> getDeployableArtifactsByModule() {
        return this.deployableArtifactsByModule;
    }

    public void getAndAppendDeployableArtifactsByModule(String deployableArtifactsPath, String backwardCompatibleDeployableArtifactsPath, FilePath ws, TaskListener listener, DeployDetails.PackageType packageType) throws IOException, InterruptedException {
        Map deployableArtifactsToAppend = (Map)ws.act((FilePath.FileCallable)new DeployPathsAndPropsCallable(deployableArtifactsPath, backwardCompatibleDeployableArtifactsPath, listener, this, packageType));
        this.appendDeployableArtifactsByModule(deployableArtifactsToAppend);
    }

    public void appendDeployableArtifactsByModule(Map<String, List<DeployDetails>> deployableArtifactsToAppend) {
        this.deployableArtifactsByModule = Stream.of(this.deployableArtifactsByModule, deployableArtifactsToAppend).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()), (current, other) -> {
            current.addAll(other);
            return current;
        }));
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Map<String, String> getEnvVars() {
        return this.env.getEnvVars();
    }

    public Map<String, String> getSysVars() {
        return this.env.getSysVars();
    }

    public org.jfrog.build.extractor.ci.Issues getConvertedIssues() {
        return this.issues.convertFromPipelineIssues();
    }

    public BuildInfoDeployer createDeployer(Run build, TaskListener listener, ArtifactoryConfigurator config, ArtifactoryManager artifactoryManager, String platformUrl) throws InterruptedException, IOException {
        return new BuildInfoDeployer(config, artifactoryManager, build, listener, this, platformUrl);
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.env.setCpsScript(cpsScript);
        this.issues.setCpsScript(cpsScript);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setRetention(BuildRetention retention) {
        this.retention = retention;
    }

    public void setDeployableArtifactsByModule(Map<String, List<DeployDetails>> deployableArtifactsByModule) {
        this.deployableArtifactsByModule = deployableArtifactsByModule;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public void setEnv(Env env) {
        this.env = env;
    }

    public void setIssues(Issues issues) {
        this.issues = issues;
    }

    private void addModule(Module other) {
        List<Module> modules = this.getModules();
        Module currentModule = modules.stream().filter(module -> StringUtils.equals((CharSequence)module.getId(), (CharSequence)other.getId())).findAny().orElse(null);
        if (currentModule == null) {
            modules.add(other);
        } else {
            currentModule.append(other);
        }
    }

    public void appendDependencies(List<Dependency> dependencies, String moduleId) {
        Module defaultModule = new ModuleBuilder().id(moduleId).dependencies(dependencies).build();
        this.addDefaultModule(defaultModule, moduleId);
    }

    public void appendArtifacts(List<Artifact> artifacts, String moduleId) {
        Module defaultModule = new ModuleBuilder().id(moduleId).artifacts(artifacts).build();
        this.addDefaultModule(defaultModule, moduleId);
    }

    private void addDefaultModule(Module defaultModule, String moduleId) {
        Module currentModule = this.getModules().stream().filter(module -> StringUtils.equals((CharSequence)module.getId(), (CharSequence)moduleId)).findAny().orElse(null);
        if (currentModule != null) {
            currentModule.append(defaultModule);
        } else {
            this.getModules().add(defaultModule);
        }
    }

    public void filterVariables() {
        this.getEnv().filter();
    }

    public void captureVariables(EnvVars envVars, Run build, TaskListener listener) {
        if (this.env.isCapture()) {
            this.env.collectVariables(envVars, build, listener);
        }
    }

    public void appendVcs(Vcs vcs) {
        if (vcs != null && !this.vcs.contains(vcs)) {
            this.vcs.add(vcs);
        }
    }

    public List<Vcs> getVcs() {
        return this.vcs;
    }

    private org.jfrog.build.extractor.ci.BuildInfo convertToBuild() {
        BuildInfoBuilder builder = new BuildInfoBuilder(this.name).number(this.number).started(Long.toString(this.startDate.getTime())).modules(this.modules).issues(this.getConvertedIssues()).properties(this.env.toProperties());
        return builder.build();
    }

    public static class DeployPathsAndPropsCallable
    extends MasterToSlaveFileCallable<Map<String, List<DeployDetails>>> {
        private String deployableArtifactsPath;
        @Deprecated
        private String backwardCompatibleDeployableArtifactsPath;
        private TaskListener listener;
        private ArrayListMultimap<String, String> propertiesMap;
        private final DeployDetails.PackageType packageType;

        DeployPathsAndPropsCallable(String deployableArtifactsPath, String backwardCompatibleDeployableArtifactsPath, TaskListener listener, BuildInfo buildInfo, DeployDetails.PackageType packageType) {
            this.deployableArtifactsPath = deployableArtifactsPath;
            this.backwardCompatibleDeployableArtifactsPath = backwardCompatibleDeployableArtifactsPath;
            this.listener = listener;
            this.propertiesMap = this.getBuildPropertiesMap(buildInfo);
            this.packageType = packageType;
        }

        public Map<String, List<DeployDetails>> invoke(File file, VirtualChannel virtualChannel) throws IOException {
            HashMap<String, List<DeployDetails>> results = new HashMap<String, List<DeployDetails>>();
            File deployableArtifactsFile = new File(this.deployableArtifactsPath);
            File backwardCompatibleDeployableArtifactsFile = new File(this.backwardCompatibleDeployableArtifactsPath);
            Map deployableArtifactsByModule = DeployableArtifactsUtils.loadDeployableArtifactsFromFile((File)deployableArtifactsFile, (File)backwardCompatibleDeployableArtifactsFile);
            deployableArtifactsFile.delete();
            backwardCompatibleDeployableArtifactsFile.delete();
            deployableArtifactsByModule.forEach((module, deployableArtifacts) -> {
                ArrayList<DeployDetails> moduleDeployDetails = new ArrayList<DeployDetails>();
                for (DeployableArtifactDetail artifact : deployableArtifacts) {
                    DeployDetails.Builder builder = new DeployDetails.Builder().file(new File(artifact.getSourcePath())).artifactPath(artifact.getArtifactDest()).addProperties(this.getDeployableArtifactPropertiesMap(artifact)).targetRepository("empty_repo").sha1(artifact.getSha1()).packageType(this.packageType);
                    moduleDeployDetails.add(builder.build());
                }
                results.put((String)module, (List<DeployDetails>)moduleDeployDetails);
            });
            return results;
        }

        private ArrayListMultimap<String, String> getDeployableArtifactPropertiesMap(DeployableArtifactDetail artifact) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            if (MapUtils.isEmpty((Map)artifact.getProperties())) {
                return this.propertiesMap;
            }
            for (String propKey : artifact.getProperties().keySet()) {
                for (String propVal : (Collection)artifact.getProperties().get(propKey)) {
                    properties.put((Object)propKey, (Object)propVal);
                }
            }
            return properties;
        }

        private ArrayListMultimap<String, String> getBuildPropertiesMap(BuildInfo buildInfo) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            properties.put((Object)"build.name", (Object)buildInfo.getName());
            properties.put((Object)"build.number", (Object)buildInfo.getNumber());
            properties.put((Object)"build.timestamp", (Object)(buildInfo.getStartDate().getTime() + ""));
            return properties;
        }
    }
}

