/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.buildInfo;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.EnvFilter;

public class Env
implements Serializable {
    private Map<String, String> envVars = new HashMap<String, String>();
    private Map<String, String> sysVars = new HashMap<String, String>();
    private EnvFilter filter = new EnvFilter();
    private boolean capture = false;
    private transient CpsScript cpsScript;

    public void collectVariables(EnvVars env, Run build, TaskListener listener) {
        this.collectVariables(env).collectBuildParameters(build, listener);
    }

    public Env collectVariables(EnvVars env) {
        this.envVars.putAll((Map<String, String>)env);
        HashMap<String, String> sysEnv = new HashMap<String, String>();
        Properties systemProperties = System.getProperties();
        Enumeration<?> enumeration = systemProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyKey = (String)enumeration.nextElement();
            sysEnv.put(propertyKey, systemProperties.getProperty(propertyKey));
        }
        this.sysVars.putAll(sysEnv);
        return this;
    }

    public Env collectBuildParameters(Run<?, ?> build, TaskListener listener) {
        EnvVars buildParameters = Utils.extractBuildParameters(build, listener);
        if (buildParameters != null) {
            this.envVars.putAll((Map<String, String>)buildParameters);
        }
        return this;
    }

    public void filter() {
        IncludeExcludePatterns pattern = this.filter.getPatternFilter();
        this.envVars.entrySet().removeIf(key -> PatternMatcher.pathConflicts((String)((String)key.getKey()), (IncludeExcludePatterns)pattern));
        this.sysVars.entrySet().removeIf(key -> PatternMatcher.pathConflicts((String)((String)key.getKey()), (IncludeExcludePatterns)pattern));
    }

    public void append(Env env) {
        this.envVars.putAll(env.envVars);
        this.sysVars.putAll(env.sysVars);
    }

    @Whitelisted
    public Map<String, String> getVars() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll(this.envVars);
        vars.putAll(this.sysVars);
        return vars;
    }

    @Whitelisted
    public boolean isCapture() {
        return this.capture;
    }

    @Whitelisted
    public void setCapture(boolean capture) {
        this.capture = capture;
    }

    @Whitelisted
    public void collect() {
        LinkedHashMap<String, Env> stepVariables = new LinkedHashMap<String, Env>();
        stepVariables.put("env", this);
        this.cpsScript.invokeMethod("collectEnv", stepVariables);
    }

    @Whitelisted
    public EnvFilter getFilter() {
        return this.filter;
    }

    public void setFilter(EnvFilter filter) {
        this.filter = filter;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public Map<String, String> getSysVars() {
        return this.sysVars;
    }

    public void setSysVars(Map<String, String> sysVars) {
        this.sysVars = sysVars;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Map<String, String> envVars = this.getEnvVars();
        Map<String, String> sysVars = this.getSysVars();
        if (envVars != null) {
            for (Map.Entry<String, String> entry : envVars.entrySet()) {
                properties.put("buildInfo.env." + entry.getKey(), entry.getValue());
            }
        }
        if (sysVars != null) {
            for (Map.Entry<String, String> entry : sysVars.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }
}

