/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.buildInfo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.extractor.ci.IssueTracker;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;

public class Issues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient CpsScript cpsScript;
    private String buildName;
    private String project;
    private String trackerName;
    private boolean aggregateBuildIssues;
    private String aggregationBuildStatus;
    private Set<Issue> affectedIssues;

    public void append(Issues issuesToAppend) {
        if (issuesToAppend == null || issuesToAppend.trackerName == null || issuesToAppend.affectedIssues == null) {
            return;
        }
        if (this.trackerName == null || this.affectedIssues == null) {
            this.trackerName = issuesToAppend.trackerName;
            this.aggregateBuildIssues = issuesToAppend.aggregateBuildIssues;
            this.aggregationBuildStatus = issuesToAppend.aggregationBuildStatus;
            this.affectedIssues = issuesToAppend.affectedIssues;
            return;
        }
        if (issuesToAppend.trackerName.equals(this.trackerName)) {
            this.appendAffectedIssues(issuesToAppend.affectedIssues);
        }
    }

    public void convertAndAppend(org.jfrog.build.extractor.ci.Issues issuesToAppend) {
        this.append(Issues.toPipelineIssues(issuesToAppend));
    }

    static Issues toPipelineIssues(org.jfrog.build.extractor.ci.Issues issuesToConvert) {
        if (issuesToConvert == null) {
            return null;
        }
        Issues newIssues = new Issues();
        if (issuesToConvert.getTracker() != null) {
            newIssues.setTrackerName(issuesToConvert.getTracker().getName());
        }
        newIssues.setAggregateBuildIssues(issuesToConvert.isAggregateBuildIssues());
        newIssues.setAggregationBuildStatus(issuesToConvert.getAggregationBuildStatus());
        Set affectedIssuesToConvert = issuesToConvert.getAffectedIssues();
        if (affectedIssuesToConvert == null) {
            return newIssues;
        }
        HashSet<Issue> convertedAffectedIssues = new HashSet<Issue>();
        for (org.jfrog.build.extractor.ci.Issue issueToConvert : affectedIssuesToConvert) {
            convertedAffectedIssues.add(new Issue(issueToConvert.getKey(), issueToConvert.getUrl(), issueToConvert.getSummary()));
        }
        newIssues.setAffectedIssues(convertedAffectedIssues);
        return newIssues;
    }

    org.jfrog.build.extractor.ci.Issues convertFromPipelineIssues() {
        IssueTracker tracker = new IssueTracker(this.getTrackerName());
        Set<Issue> affectedIssuesToConvert = this.getAffectedIssues();
        if (affectedIssuesToConvert == null) {
            return new org.jfrog.build.extractor.ci.Issues(tracker, this.isAggregateBuildIssues(), this.getAggregationBuildStatus(), null);
        }
        HashSet<org.jfrog.build.extractor.ci.Issue> convertedAffectedIssues = new HashSet<org.jfrog.build.extractor.ci.Issue>();
        for (Issue issueToConvert : affectedIssuesToConvert) {
            convertedAffectedIssues.add(new org.jfrog.build.extractor.ci.Issue(issueToConvert.getKey(), issueToConvert.getUrl(), issueToConvert.getSummary()));
        }
        return new org.jfrog.build.extractor.ci.Issues(tracker, this.isAggregateBuildIssues(), this.getAggregationBuildStatus(), convertedAffectedIssues);
    }

    private void appendAffectedIssues(Set<Issue> affectedIssuesToAppend) {
        if (affectedIssuesToAppend == null) {
            return;
        }
        if (this.affectedIssues == null) {
            this.affectedIssues = affectedIssuesToAppend;
            return;
        }
        this.affectedIssues.addAll(affectedIssuesToAppend);
    }

    @Whitelisted
    public void collect(ArtifactoryServer server, String config) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put("issues", this);
        stepVariables.put("server", server);
        stepVariables.put("config", config);
        this.cpsScript.invokeMethod("collectIssues", stepVariables);
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public void setTrackerName(String trackerName) {
        this.trackerName = trackerName;
    }

    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    public void setAggregateBuildIssues(boolean aggregateBuildIssues) {
        this.aggregateBuildIssues = aggregateBuildIssues;
    }

    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public void setAggregationBuildStatus(String aggregationBuildStatus) {
        this.aggregationBuildStatus = aggregationBuildStatus;
    }

    @Whitelisted
    public Set<Issue> getAffectedIssues() {
        return this.affectedIssues;
    }

    public void setAffectedIssues(Set<Issue> affectedIssues) {
        this.affectedIssues = affectedIssues;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public CpsScript getCpsScript() {
        return this.cpsScript;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public static class Issue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String key;
        private String url;
        private String summary;
        private boolean aggregated;

        public Issue() {
        }

        public Issue(String key, String url, String summary) {
            this.key = key;
            this.url = url;
            this.summary = summary;
            this.aggregated = false;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getSummary() {
            return this.summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public boolean isAggregated() {
            return this.aggregated;
        }

        public void setAggregated(boolean aggregated) {
            this.aggregated = aggregated;
        }
    }
}

