/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.builds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.CommonDeployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;

public class GoBuild
extends PackageManagerBuild {
    public static final String GO_BUILD = "goBuild";
    public static final String GO_CMD_ARGS = "goCmdArgs";
    public static final String VERSION = "version";
    public static final String JAVA_ARGS = "javaArgs";

    public GoBuild() {
        this.deployer = new CommonDeployer();
        this.resolver = new CommonResolver();
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("repo", "server"));
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        this.setDeployer(deployerArguments, Arrays.asList("repo", "server", "includeEnvVars"));
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareGoStep(args, Arrays.asList("path", "args", "buildInfo", "module", JAVA_ARGS));
        stepVariables.put(GO_CMD_ARGS, args.get("args"));
        this.cpsScript.invokeMethod("artifactoryGoRun", stepVariables);
    }

    @Whitelisted
    public void publish(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareGoStep(args, Arrays.asList("path", VERSION, "buildInfo", "module", JAVA_ARGS));
        stepVariables.put(VERSION, args.get(VERSION));
        this.cpsScript.invokeMethod("artifactoryGoPublish", stepVariables);
    }

    private Map<String, Object> prepareGoStep(Map<String, Object> args, List<String> keysAsList) {
        Set<String> argumentsSet = args.keySet();
        if (!keysAsList.containsAll(argumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getGoArguments((String)args.get("path"), (String)args.get("module"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        stepVariables.put(JAVA_ARGS, args.get(JAVA_ARGS));
        return stepVariables;
    }

    private Map<String, Object> getGoArguments(String path, String module, BuildInfo buildInfo) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put(GO_BUILD, this);
        stepVariables.put("path", path);
        stepVariables.put("module", module);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

