/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.builds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.GradleDeployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.GradleResolver;

public class GradleBuild
extends PackageManagerBuild {
    private boolean useWrapper;
    private boolean usesPlugin;

    public GradleBuild() {
        this.deployer = new GradleDeployer();
        this.resolver = new GradleResolver();
    }

    @Whitelisted
    public boolean isUsesPlugin() {
        return this.usesPlugin;
    }

    @Whitelisted
    public void setUsesPlugin(boolean usesPlugin) {
        this.usesPlugin = usesPlugin;
    }

    @Whitelisted
    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    @Whitelisted
    public void setUseWrapper(boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("repo", "server"));
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        this.setDeployer(deployerArguments, Arrays.asList("repo", "snapshotRepo", "releaseRepo", "server", "deployArtifacts", "includeEnvVars", "usesPlugin", "deployMaven", "deployIvy", "ivyPattern", "artifactPattern", "publications"));
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        if (!args.containsKey("tasks")) {
            throw new IllegalArgumentException("tasks is a mandatory argument.");
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getRunArguments((String)args.get("buildFile"), (String)args.get("tasks"), (String)args.get("switches"), (String)args.get("rootDir"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("ArtifactoryGradleBuild", stepVariables);
    }

    private Map<String, Object> getRunArguments(String buildFile, String tasks, String switches, String rootDir, BuildInfo buildInfo) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put("gradleBuild", this);
        stepVariables.put("rootDir", rootDir);
        stepVariables.put("buildFile", buildFile);
        stepVariables.put("tasks", tasks);
        stepVariables.put("switches", switches);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

