/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.builds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.CommonDeployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;

public class NpmBuild
extends PackageManagerBuild {
    public static final String NPM_BUILD = "npmBuild";
    public static final String JAVA_ARGS = "javaArgs";
    public static final String DEPLOY_ARTIFACTS = "deployArtifacts";

    public NpmBuild() {
        this.deployer = new CommonDeployer();
        this.resolver = new CommonResolver();
    }

    @Whitelisted
    public void install(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareNpmStep(args, Arrays.asList("path", JAVA_ARGS, "args", "buildInfo", "module"));
        stepVariables.put("args", args.get("args"));
        this.cpsScript.invokeMethod("artifactoryNpmInstall", stepVariables);
    }

    @Whitelisted
    public void ci(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareNpmStep(args, Arrays.asList("path", JAVA_ARGS, "args", "buildInfo", "module"));
        stepVariables.put("args", args.get("args"));
        this.cpsScript.invokeMethod("artifactoryNpmCi", stepVariables);
    }

    @Whitelisted
    public void publish(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareNpmStep(args, Arrays.asList("path", JAVA_ARGS, "buildInfo", "module"));
        this.cpsScript.invokeMethod("artifactoryNpmPublish", stepVariables);
    }

    private Map<String, Object> prepareNpmStep(Map<String, Object> args, List<String> keysAsList) {
        Set<String> npmArgumentsSet = args.keySet();
        if (!keysAsList.containsAll(npmArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        this.deployer.setCpsScript(this.cpsScript);
        Map<String, Object> stepVariables = this.getRunArguments((String)args.get("path"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        stepVariables.put("module", args.get("module"));
        stepVariables.put(JAVA_ARGS, args.get(JAVA_ARGS));
        return stepVariables;
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("repo", "server"));
    }

    @Whitelisted
    public void deployer(Map<String, Object> deployerArguments) throws Exception {
        this.setDeployer(deployerArguments, Arrays.asList("repo", "server", DEPLOY_ARTIFACTS, "includeEnvVars"));
    }

    private Map<String, Object> getRunArguments(String path, BuildInfo buildInfo) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put(NPM_BUILD, this);
        stepVariables.put("path", path);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

