/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.builds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;

public class PipBuild
extends PackageManagerBuild {
    public static final String PIP_BUILD = "pipBuild";
    public static final String JAVA_ARGS = "javaArgs";
    public static final String ENV_ACTIVATION = "envActivation";

    public PipBuild() {
        this.resolver = new CommonResolver();
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("repo", "server"));
    }

    @Whitelisted
    public void install(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.preparePipStep(args, Arrays.asList(JAVA_ARGS, "args", "buildInfo", ENV_ACTIVATION, "module"));
        this.cpsScript.invokeMethod("artifactoryPipRun", stepVariables);
    }

    private Map<String, Object> preparePipStep(Map<String, Object> args, List<String> keysAsList) {
        Set<String> argumentsSet = args.keySet();
        if (!keysAsList.containsAll(argumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        Map<String, Object> stepVariables = this.getPipArguments((String)args.get("args"), (String)args.get("module"), (BuildInfo)args.get("buildInfo"), (String)args.get(JAVA_ARGS), (String)args.get(ENV_ACTIVATION));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        return stepVariables;
    }

    private Map<String, Object> getPipArguments(String args, String module, BuildInfo buildInfo, String javaArgs, String envActivation) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put(PIP_BUILD, this);
        stepVariables.put("args", args);
        stepVariables.put("module", module);
        stepVariables.put("buildInfo", buildInfo);
        stepVariables.put(JAVA_ARGS, javaArgs);
        stepVariables.put(ENV_ACTIVATION, envActivation);
        return stepVariables;
    }
}

