/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.deployers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.ModuleParallelDeployHelper;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.pipeline.action.DeployedArtifact;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.Filter;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Env;
import org.jfrog.hudson.pipeline.common.types.deployers.GradleDeployer;
import org.jfrog.hudson.pipeline.common.types.deployers.MavenDeployer;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;

public abstract class Deployer
implements DeployerOverrider,
Serializable {
    private boolean deployArtifacts = true;
    private boolean includeEnvVars;
    private ArrayListMultimap<String, String> properties = ArrayListMultimap.create();
    private Filter artifactDeploymentPatterns = new Filter();
    private String customBuildName = "";
    private int threads = 3;
    private transient CpsScript cpsScript;
    protected transient org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;

    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    public Deployer setIncludeEnvVars(boolean includeEnvVars) {
        this.includeEnvVars = includeEnvVars;
        return this;
    }

    public ArtifactoryServer getArtifactoryServer() {
        return Utils.prepareArtifactoryServer(null, this.server);
    }

    @Whitelisted
    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    @Whitelisted
    public Deployer setServer(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.server = server;
        return this;
    }

    @Whitelisted
    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    @Whitelisted
    public Deployer setDeployArtifacts(boolean deployArtifacts) {
        this.deployArtifacts = deployArtifacts;
        return this;
    }

    @Whitelisted
    public int getThreads() {
        return this.threads;
    }

    @Whitelisted
    public Deployer setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    @Whitelisted
    public Deployer addProperty(String key, String ... values) {
        this.properties.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    public ArrayListMultimap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayListMultimap<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return false;
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return null;
    }

    @Override
    @JsonIgnore
    public CredentialsConfig getDeployerCredentialsConfig() {
        try {
            return this.getArtifactoryServer().getDeployerCredentialsConfig();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Artifactory server is missing.");
        }
    }

    public boolean isDeployBuildInfo() {
        return false;
    }

    @Whitelisted
    public Filter getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    public void setArtifactDeploymentPatterns(Filter artifactDeploymentPatterns) {
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
    }

    public IncludesExcludes getArtifactsIncludeExcludeForDeyployment() {
        return Utils.getArtifactsIncludeExcludeForDeyployment(this.artifactDeploymentPatterns.getPatternFilter());
    }

    public void createPublisherBuildInfoDetails(BuildInfo buildInfo) {
        if (buildInfo != null) {
            Env buildInfoEnv = buildInfo.getEnv();
            this.setIncludeEnvVars(buildInfoEnv.isCapture());
            this.setCustomBuildName(buildInfo.getName());
        }
    }

    public String getCustomBuildName() {
        return this.customBuildName;
    }

    public void setCustomBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    public abstract ServerDetails getDetails() throws IOException;

    public abstract PublisherContext.Builder getContextBuilder() throws IOException;

    public abstract boolean isEmpty();

    public abstract String getTargetRepository(String var1);

    public CpsScript getCpsScript() {
        return this.cpsScript;
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    @Whitelisted
    public void deployArtifacts(BuildInfo buildInfo) {
        LinkedHashMap<String, Serializable> stepVariables = new LinkedHashMap<String, Serializable>();
        stepVariables.put("deployer", this);
        stepVariables.put("buildInfo", buildInfo);
        this.cpsScript.invokeMethod("deployArtifacts", stepVariables);
    }

    public void deployArtifacts(BuildInfo buildInfo, TaskListener listener, FilePath ws, Run build) throws IOException, InterruptedException {
        if (buildInfo.getDeployableArtifactsByModule().isEmpty()) {
            listener.getLogger().println("No artifacts for deployment were found");
            return;
        }
        String agentName = Utils.getAgentName(ws);
        if (buildInfo.getAgentName().equals(agentName)) {
            ArtifactoryServer artifactoryServer = Utils.prepareArtifactoryServer(null, this.server);
            Credentials credentials = this.getDeployerCredentialsConfig().provideCredentials((Item)build.getParent());
            if (credentials == Credentials.EMPTY_CREDENTIALS) {
                throw new RuntimeException(String.format("No matching credentials was found in Jenkins for the supplied credentialsId: '%s' ", this.getDeployerCredentialsConfig().getCredentialsId()));
            }
            ProxyConfiguration proxy = ProxyUtils.createProxyConfiguration();
            Map deployableArtifactsByModule = (Map)ws.act((FilePath.FileCallable)new DeployDetailsCallable(buildInfo.getDeployableArtifactsByModule(), listener, this));
            if (deployableArtifactsByModule == null) {
                throw new RuntimeException("Deployment failed");
            }
            if (!deployableArtifactsByModule.isEmpty()) {
                ws.act((FilePath.FileCallable)new LateDeployCallable(listener, deployableArtifactsByModule, artifactoryServer, credentials, proxy, this.getThreads()));
                Deployer.addDeployedArtifactsActionFromDetails(build, artifactoryServer.getArtifactoryUrl(), deployableArtifactsByModule);
            }
        } else {
            throw new RuntimeException("Cannot deploy the files from agent: " + agentName + " since they were built on agent: " + buildInfo.getAgentName());
        }
    }

    public static void addDeployedArtifactsActionFromDetails(Run<?, ?> build, String artifactoryUrl, Map<String, Set<DeployDetails>> deployableArtifactsByModule) {
        deployableArtifactsByModule.forEach((module, detailsSet) -> {
            ArrayList<DeployedArtifact> curArtifacts = new ArrayList<DeployedArtifact>();
            DeployDetails.PackageType packageType = DeployDetails.PackageType.MAVEN;
            for (DeployDetails curDetails : detailsSet) {
                DeployedArtifact deployedArtifact = new DeployedArtifact(artifactoryUrl, curDetails.getTargetRepository(), curDetails.getArtifactPath(), FilenameUtils.getName((String)curDetails.getArtifactPath()));
                packageType = curDetails.getPackageType();
                curArtifacts.add(deployedArtifact);
            }
            Deployer.addDeployedArtifactsToAction(build, curArtifacts, packageType);
        });
    }

    public static void addDeployedArtifactsActionFromModules(Run<?, ?> build, String artifactoryUrl, List<Module> modules, DeployDetails.PackageType packageType) {
        ArrayList<DeployedArtifact> curArtifacts = new ArrayList<DeployedArtifact>();
        for (Module module : modules) {
            if (module.getArtifacts() == null) continue;
            for (Artifact artifact : module.getArtifacts()) {
                curArtifacts.add(new DeployedArtifact(artifactoryUrl, module.getRepository(), artifact.getRemotePath(), artifact.getName()));
            }
        }
        Deployer.addDeployedArtifactsToAction(build, curArtifacts, packageType);
    }

    public static void addDeployedArtifactsToAction(Run<?, ?> build, List<DeployedArtifact> artifacts, DeployDetails.PackageType packageType) {
        if (artifacts.isEmpty()) {
            return;
        }
        switch (packageType) {
            case MAVEN: {
                MavenDeployer.addDeployedMavenArtifactsToAction(build, artifacts);
                break;
            }
            case GRADLE: {
                GradleDeployer.addDeployedGradleArtifactsToAction(build, artifacts);
            }
        }
    }

    public static class LateDeployCallable
    extends MasterToSlaveFileCallable<Void> {
        private final TaskListener listener;
        private final ArtifactoryServer server;
        private final Credentials credentials;
        private final ProxyConfiguration proxyConfiguration;
        private final Map<String, Set<DeployDetails>> deployableArtifactsByModule;
        private final int threads;

        public LateDeployCallable(TaskListener listener, Map<String, Set<DeployDetails>> deployableArtifactsByModule, ArtifactoryServer server, Credentials credentials, ProxyConfiguration proxyConfiguration, int threads) {
            this.listener = listener;
            this.deployableArtifactsByModule = deployableArtifactsByModule;
            this.server = server;
            this.credentials = credentials;
            this.proxyConfiguration = proxyConfiguration;
            this.threads = threads;
        }

        public Void invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            ArtifactoryManagerBuilder artifactoryManagerBuilder = this.server.createArtifactoryManagerBuilder(this.credentials, this.proxyConfiguration, log);
            try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
                new ModuleParallelDeployHelper().deployArtifacts(artifactoryManager, this.deployableArtifactsByModule, this.threads);
            }
            return null;
        }
    }

    public static class DeployDetailsCallable
    extends MasterToSlaveFileCallable<Map<String, Set<DeployDetails>>> {
        private static final String SHA1 = "SHA1";
        private static final String MD5 = "MD5";
        private Map<String, List<DeployDetails>> deployableArtifactsPaths;
        private TaskListener listener;
        private Deployer deployer;

        DeployDetailsCallable(Map<String, List<DeployDetails>> deployableArtifactsPaths, TaskListener listener, Deployer deployer) {
            this.deployableArtifactsPaths = deployableArtifactsPaths;
            this.listener = listener;
            this.deployer = deployer;
        }

        public Map<String, Set<DeployDetails>> invoke(File file, VirtualChannel virtualChannel) throws IOException {
            boolean isSuccess = true;
            LinkedHashMap<String, Set<DeployDetails>> results = new LinkedHashMap<String, Set<DeployDetails>>();
            for (Map.Entry<String, List<DeployDetails>> entry : this.deployableArtifactsPaths.entrySet()) {
                String module = entry.getKey();
                List<DeployDetails> paths = entry.getValue();
                try {
                    LinkedHashSet<DeployDetails> deployDetails = new LinkedHashSet<DeployDetails>();
                    for (DeployDetails artifact : paths) {
                        String artifactPath = artifact.getArtifactPath();
                        if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)this.deployer.getArtifactDeploymentPatterns().getPatternFilter())) {
                            this.listener.getLogger().println("Artifactory Deployer: Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
                            continue;
                        }
                        Map checksums = FileChecksumCalculator.calculateChecksums((File)artifact.getFile(), (String[])new String[]{SHA1, MD5});
                        if (!((String)checksums.get(SHA1)).equals(artifact.getSha1())) {
                            this.listener.error("SHA1 mismatch at '" + artifactPath + "' expected: " + artifact.getSha1() + ", got " + (String)checksums.get(SHA1) + ". Make sure that the same artifacts were not built more than once.");
                            isSuccess = false;
                            continue;
                        }
                        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifact.getFile()).artifactPath(artifactPath).targetRepository(this.deployer.getTargetRepository(artifactPath)).md5((String)checksums.get(MD5)).sha1(artifact.getSha1()).addProperties((Multimap)artifact.getProperties()).addProperties(this.deployer.getProperties()).packageType(artifact.getPackageType());
                        deployDetails.add(builder.build());
                    }
                    results.put(module, deployDetails);
                }
                catch (NoSuchAlgorithmException e) {
                    this.listener.error("Could not find checksum algorithm for SHA1 or MD5");
                    isSuccess = false;
                }
            }
            return isSuccess ? results : null;
        }
    }
}

