/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.deployers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hudson.model.Action;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.action.DeployedArtifact;
import org.jfrog.hudson.pipeline.action.DeployedGradleArtifactsAction;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.GradlePublications;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class GradleDeployer
extends Deployer {
    private static final String repoValidationMessage = "The Deployer should be set with either 'repo' or both 'releaseRepo' and 'snapshotRepo'";
    private GradlePublications publications = new GradlePublications();
    private Boolean deployMavenDescriptors;
    private Boolean deployIvyDescriptors;
    private String ivyPattern = "[organisation]/[module]/ivy-[revision].xml";
    private String artifactPattern = "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]";
    private boolean mavenCompatible = true;
    private String repo;
    private String releaseRepo;
    private String snapshotRepo;

    @Override
    @JsonIgnore
    public ServerDetails getDetails() throws IOException {
        RepositoryConf releaseRepositoryConf;
        this.validateRepositories();
        RepositoryConf snapshotRepositoryConf = null;
        if (StringUtils.isNotEmpty((CharSequence)this.repo)) {
            releaseRepositoryConf = new RepositoryConf(this.repo, this.repo, false);
        } else {
            releaseRepositoryConf = new RepositoryConf(this.releaseRepo, this.releaseRepo, false);
            snapshotRepositoryConf = new RepositoryConf(this.snapshotRepo, this.snapshotRepo, false);
        }
        return new ServerDetails(this.server.getServerName(), this.server.getUrl(), releaseRepositoryConf, snapshotRepositoryConf, releaseRepositoryConf, null, "", "");
    }

    @JsonIgnore
    private void validateRepositories() throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)this.repo)) {
            if (StringUtils.isNotEmpty((CharSequence)this.releaseRepo) || StringUtils.isNotEmpty((CharSequence)this.snapshotRepo)) {
                throw new IOException(repoValidationMessage);
            }
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.releaseRepo) || StringUtils.isEmpty((CharSequence)this.snapshotRepo)) {
            throw new IOException(repoValidationMessage);
        }
    }

    @Whitelisted
    public Boolean isDeployMavenDescriptors() {
        return this.deployMavenDescriptors;
    }

    @Whitelisted
    public void setDeployMavenDescriptors(boolean deployMavenDescriptors) {
        this.deployMavenDescriptors = deployMavenDescriptors;
    }

    @Whitelisted
    public Boolean isDeployIvyDescriptors() {
        return this.deployIvyDescriptors;
    }

    @Whitelisted
    public void setDeployIvyDescriptors(boolean deployIvyDescriptors) {
        this.deployIvyDescriptors = deployIvyDescriptors;
    }

    @Whitelisted
    public String getIvyPattern() {
        return this.ivyPattern;
    }

    @Whitelisted
    public void setIvyPattern(String ivyPattern) {
        this.ivyPattern = ivyPattern;
    }

    @Whitelisted
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Whitelisted
    public void setArtifactPattern(String artifactPattern) {
        this.artifactPattern = artifactPattern;
    }

    @Whitelisted
    public boolean getMavenCompatible() {
        return this.mavenCompatible;
    }

    @Whitelisted
    public void setMavenCompatible(boolean mavenCompatible) {
        this.mavenCompatible = mavenCompatible;
    }

    @Whitelisted
    public boolean isMavenCompatible() {
        return this.mavenCompatible;
    }

    @Whitelisted
    public String getRepo() {
        return this.repo;
    }

    @Whitelisted
    public void setRepo(String repo) {
        this.repo = repo;
    }

    @Whitelisted
    public String getSnapshotRepo() {
        return this.snapshotRepo;
    }

    @Whitelisted
    public void setSnapshotRepo(String snapshotRepo) {
        this.snapshotRepo = snapshotRepo;
    }

    @Whitelisted
    public String getReleaseRepo() {
        return this.releaseRepo;
    }

    @Whitelisted
    public void setReleaseRepo(String releaseRepo) {
        this.releaseRepo = releaseRepo;
    }

    @Whitelisted
    public GradlePublications getPublications() {
        return this.publications;
    }

    @Whitelisted
    public void setPublications(GradlePublications publications) {
        this.publications = publications;
    }

    @Override
    public boolean isEmpty() {
        return this.server == null || StringUtils.isEmpty((CharSequence)this.repo) && StringUtils.isEmpty((CharSequence)this.snapshotRepo) && StringUtils.isEmpty((CharSequence)this.releaseRepo);
    }

    @Override
    public String getTargetRepository(String deployPath) {
        if (StringUtils.isNotBlank((CharSequence)this.snapshotRepo) && deployPath.contains("-SNAPSHOT")) {
            return this.snapshotRepo;
        }
        return StringUtils.isNotBlank((CharSequence)this.releaseRepo) ? this.releaseRepo : this.repo;
    }

    @Override
    @JsonIgnore
    public PublisherContext.Builder getContextBuilder() throws IOException {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).serverDetails(this.getDetails()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(Utils.getArtifactsIncludeExcludeForDeyployment(this.getArtifactDeploymentPatterns().getPatternFilter())).threads(this.getThreads()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).artifactsPattern(this.getArtifactPattern()).ivyPattern(this.getIvyPattern()).deployIvy(this.isDeployIvyDescriptors()).deployMaven(this.isDeployMavenDescriptors()).deployerOverrider(this).includeEnvVars(this.isIncludeEnvVars()).maven2Compatible(this.getMavenCompatible()).deploymentProperties(DeploymentUrlUtils.buildMatrixParamsString(this.getProperties(), (boolean)false)).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).publications(this.getPublications().getPublications());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeployedGradleArtifactsToAction(Run<?, ?> build, List<DeployedArtifact> gradleArtifacts) {
        List list = build.getAllActions();
        synchronized (list) {
            DeployedGradleArtifactsAction action = (DeployedGradleArtifactsAction)build.getAction(DeployedGradleArtifactsAction.class);
            if (action == null) {
                action = new DeployedGradleArtifactsAction(build);
                build.addAction((Action)action);
            }
            action.appendDeployedArtifacts(gradleArtifacts);
        }
    }
}

