/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.deployers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hudson.model.Action;
import hudson.model.Run;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.action.DeployedArtifact;
import org.jfrog.hudson.pipeline.action.DeployedMavenArtifactsAction;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.util.publisher.PublisherContext;

public class MavenDeployer
extends Deployer {
    private String snapshotRepo;
    private String releaseRepo;
    private boolean deployEvenIfUnstable = false;
    public static final MavenDeployer EMPTY_DEPLOYER = MavenDeployer.createEmptyDeployer();

    @Whitelisted
    public String getReleaseRepo() {
        return this.releaseRepo;
    }

    @Whitelisted
    public MavenDeployer setReleaseRepo(String releaseRepo) {
        this.releaseRepo = releaseRepo;
        return this;
    }

    @Whitelisted
    public MavenDeployer setSnapshotRepo(String snapshotRepo) {
        this.snapshotRepo = snapshotRepo;
        return this;
    }

    @Whitelisted
    public String getSnapshotRepo() {
        return this.snapshotRepo;
    }

    @Whitelisted
    public Deployer setDeployEvenIfUnstable(boolean deployEvenIfUnstable) {
        this.deployEvenIfUnstable = deployEvenIfUnstable;
        return this;
    }

    @Whitelisted
    public boolean isDeployEvenIfUnstable() {
        return this.deployEvenIfUnstable;
    }

    @Override
    @JsonIgnore
    public ServerDetails getDetails() {
        RepositoryConf snapshotRepositoryConf = new RepositoryConf(this.snapshotRepo, this.snapshotRepo, false);
        RepositoryConf releaseRepositoryConf = new RepositoryConf(this.releaseRepo, this.releaseRepo, false);
        return new ServerDetails(this.server.getServerName(), this.server.getUrl(), releaseRepositoryConf, snapshotRepositoryConf, releaseRepositoryConf, snapshotRepositoryConf, "", "");
    }

    @Override
    @JsonIgnore
    public PublisherContext.Builder getContextBuilder() throws UnsupportedEncodingException {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).deployerOverrider(this).serverDetails(this.getDetails()).deployArtifacts(this.isDeployArtifacts()).threads(this.getThreads()).evenIfUnstable(this.isDeployEvenIfUnstable()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).includeEnvVars(this.isIncludeEnvVars()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).deploymentProperties(DeploymentUrlUtils.buildMatrixParamsString(this.getProperties(), (boolean)false)).includesExcludes(this.getArtifactsIncludeExcludeForDeyployment());
    }

    @Override
    public boolean isEmpty() {
        return this.server == null || StringUtils.isEmpty((CharSequence)this.releaseRepo) && StringUtils.isEmpty((CharSequence)this.snapshotRepo);
    }

    @Override
    public String getTargetRepository(String deployPath) {
        return StringUtils.isNotBlank((CharSequence)this.snapshotRepo) && deployPath.contains("-SNAPSHOT") ? this.snapshotRepo : this.releaseRepo;
    }

    private static MavenDeployer createEmptyDeployer() {
        MavenDeployer dummy = new MavenDeployer();
        ArtifactoryServer server = new ArtifactoryServer("http://empty_url", "user", "password");
        dummy.setServer(server);
        dummy.setReleaseRepo("empty_repo");
        dummy.setSnapshotRepo("empty_repo");
        dummy.setDeployArtifacts(false);
        dummy.setDeployEvenIfUnstable(false);
        dummy.setThreads(1);
        return dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeployedMavenArtifactsToAction(Run<?, ?> build, List<DeployedArtifact> mavenArtifacts) {
        List list = build.getAllActions();
        synchronized (list) {
            DeployedMavenArtifactsAction action = (DeployedMavenArtifactsAction)build.getAction(DeployedMavenArtifactsAction.class);
            if (action == null) {
                action = new DeployedMavenArtifactsAction(build);
                build.addAction((Action)action);
            }
            action.appendDeployedArtifacts(mavenArtifacts);
        }
    }
}

