/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BuildInfoStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtBuildInfo";
    private final BuildInfo buildInfo = new BuildInfo();

    @DataBoundConstructor
    public BuildInfoStep() {
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildInfo.setName(buildName);
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.buildInfo.setNumber(buildNumber);
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.buildInfo.setProject(project);
    }

    @DataBoundSetter
    public void setStartDate(Date date) {
        this.buildInfo.setStartDate(date);
    }

    @DataBoundSetter
    public void setCaptureEnv(boolean capture) {
        this.buildInfo.getEnv().setCapture(capture);
    }

    @DataBoundSetter
    public void setIncludeEnvPatterns(List<String> includeEnvPatterns) {
        includeEnvPatterns.forEach(pattern -> this.buildInfo.getEnv().getFilter().addInclude((String)pattern));
    }

    @DataBoundSetter
    public void setExcludeEnvPatterns(List<String> excludeEnvPatterns) {
        excludeEnvPatterns.forEach(pattern -> this.buildInfo.getEnv().getFilter().addExclude((String)pattern));
    }

    @DataBoundSetter
    public void setMaxBuilds(int maxBuilds) {
        this.buildInfo.getRetention().setMaxBuilds(maxBuilds);
    }

    @DataBoundSetter
    public void setAsyncBuildRetention(boolean async) {
        this.buildInfo.getRetention().setAsync(async);
    }

    @DataBoundSetter
    public void setDeleteBuildArtifacts(boolean deleteBuildArtifact) {
        this.buildInfo.getRetention().setDeleteBuildArtifacts(deleteBuildArtifact);
    }

    @DataBoundSetter
    public void setDoNotDiscardBuilds(List<String> buildNumbersNotToBeDiscarded) {
        this.buildInfo.getRetention().setDoNotDiscardBuilds(buildNumbersNotToBeDiscarded);
    }

    @DataBoundSetter
    public void setMaxDays(int days) {
        this.buildInfo.getRetention().setMaxDays(days);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return BuildInfoStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Create build info";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Void> {
        private final transient BuildInfoStep step;

        @Inject
        public Execution(BuildInfoStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            String buildName = StringUtils.isBlank((CharSequence)this.step.buildInfo.getName()) ? BuildUniqueIdentifierHelper.getBuildName((Run)this.build) : this.step.buildInfo.getName();
            String buildNumber = StringUtils.isBlank((CharSequence)this.step.buildInfo.getNumber()) ? BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build) : this.step.buildInfo.getNumber();
            String project = this.step.buildInfo.getProject();
            this.step.buildInfo.setName(buildName);
            this.step.buildInfo.setNumber(buildNumber);
            this.step.buildInfo.setProject(project);
            BuildInfo currentBuildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, buildName, buildNumber, project);
            this.step.buildInfo.append(currentBuildInfo);
            DeclarativePipelineUtils.saveBuildInfo(this.step.buildInfo, this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws Exception {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }
    }
}

