/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.BuildTriggerExecutor;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildTriggerStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtBuildTrigger";
    private final String serverId;
    private final String paths;
    private final String spec;

    @DataBoundConstructor
    public BuildTriggerStep(String serverId, String paths, String spec) {
        this.serverId = serverId;
        this.paths = paths;
        this.spec = spec;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return BuildTriggerStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Trigger Artifactory build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient BuildTriggerStep step;

        @Inject
        public Execution(BuildTriggerStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            new BuildTriggerExecutor((Run<?, ?>)this.build, this.listener, server, this.step.paths, this.step.spec).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            return Utils.prepareArtifactoryServer(null, server);
        }

        @Override
        public String getUsageReportFeatureName() {
            return BuildTriggerStep.STEP_NAME;
        }
    }
}

