/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CreateJFrogInstanceStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "jfrogInstance";
    private final String id;
    private Integer deploymentThreads;
    private String distributionUrl;
    private String artifactoryUrl;
    private String credentialsId;
    private Boolean bypassProxy;
    private String username;
    private String password;
    private Integer timeout;
    private Integer retry;
    private String url;

    @DataBoundConstructor
    public CreateJFrogInstanceStep(String id) {
        this.id = id;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    @DataBoundSetter
    public void setDistributionUrl(String distributionUrl) {
        this.distributionUrl = distributionUrl;
    }

    @DataBoundSetter
    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setBypassProxy(boolean bypassProxy) {
        this.bypassProxy = bypassProxy;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @DataBoundSetter
    public void setRetry(int retry) {
        this.retry = retry;
    }

    @DataBoundSetter
    public void setDeploymentThreads(int deploymentThreads) {
        this.deploymentThreads = deploymentThreads;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CreateJFrogInstanceStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Creates new JFrog instance";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Void> {
        private final transient CreateJFrogInstanceStep step;

        @Inject
        public Execution(CreateJFrogInstanceStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            JFrogPlatformInstance server = DeclarativePipelineUtils.getJFrogPlatformInstance(this.build, this.ws, this.step.id, false);
            if (server == null) {
                server = new JFrogPlatformInstance();
            }
            this.checkInputs(server);
            this.overrideServerParameters(server);
            BuildDataFile buildDataFile = new BuildDataFile(CreateJFrogInstanceStep.STEP_NAME, this.step.id);
            buildDataFile.putPOJO(server);
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build);
            DeclarativePipelineUtils.writeBuildDataFile(this.rootWs, buildNumber, buildDataFile, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws Exception {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }

        private void checkInputs(JFrogPlatformInstance server) throws IOException {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{server.getUrl(), server.getArtifactory().getUrl(), server.getDistribution().getUrl(), this.step.url, this.step.artifactoryUrl, this.step.distributionUrl})) {
                throw new IOException("Server URL is missing");
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.credentialsId)) {
                if (StringUtils.isNotBlank((CharSequence)this.step.username)) {
                    throw new IOException("'rtServer' step can't include both credentialsId and username");
                }
                if (StringUtils.isNotBlank((CharSequence)this.step.password)) {
                    throw new IOException("'rtServer' step can't include both credentialsId and password");
                }
            }
        }

        private void overrideServerParameters(JFrogPlatformInstance server) {
            if (StringUtils.isNotBlank((CharSequence)this.step.url)) {
                server.setUrl(this.step.url);
                String urlWithoutSlash = StringUtils.removeEnd((String)this.step.url, (String)"/");
                server.getArtifactory().setPlatformUrl(urlWithoutSlash);
                server.getArtifactory().setUrl(urlWithoutSlash + "/artifactory");
                server.getDistribution().setUrl(urlWithoutSlash + "/distribution");
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.artifactoryUrl)) {
                server.getArtifactory().setUrl(this.step.artifactoryUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.distributionUrl)) {
                server.getDistribution().setUrl(this.step.distributionUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.credentialsId)) {
                server.getArtifactory().setCredentialsId(this.step.credentialsId);
                server.getDistribution().setCredentialsId(this.step.credentialsId);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.username)) {
                server.getArtifactory().setUsername(this.step.username);
                server.getDistribution().setUsername(this.step.username);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.password)) {
                server.getArtifactory().setPassword(this.step.password);
                server.getDistribution().setPassword(this.step.password);
            }
            if (this.step.deploymentThreads != null) {
                server.getArtifactory().setDeploymentThreads(this.step.deploymentThreads);
            }
            if (this.step.bypassProxy != null) {
                server.getArtifactory().setBypassProxy(this.step.bypassProxy);
            }
            if (this.step.retry != null) {
                server.getArtifactory().getConnection().setRetry(this.step.retry);
            }
            if (this.step.timeout != null) {
                server.getArtifactory().getConnection().setTimeout(this.step.timeout);
            }
        }
    }
}

