/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.pipeline.declarative.steps.PromoteBuildStep;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InteractivePromotionStep
extends PromoteBuildStep {
    public static final String STEP_NAME = "rtAddInteractivePromotion";
    private String displayName;

    @DataBoundConstructor
    public InteractivePromotionStep(String serverId) {
        super(serverId, "");
    }

    @DataBoundSetter
    public void setTargetRepo(String targetRepo) {
        this.promotionConfig.setTargetRepo(targetRepo);
    }

    @DataBoundSetter
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return InteractivePromotionStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Add interactive promotion";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Boolean> {
        private final transient InteractivePromotionStep step;

        @Inject
        public Execution(InteractivePromotionStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(Utils.prepareArtifactoryServer(null, server));
            this.addPromotionAction(configurator);
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws Exception {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            return Utils.prepareArtifactoryServer(null, server);
        }

        @Override
        public String getUsageReportFeatureName() {
            return InteractivePromotionStep.STEP_NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPromotionAction(ArtifactoryConfigurator configurator) {
            PromotionConfig pipelinePromotionConfig = this.step.preparePromotionConfig((Run<?, ?>)this.build);
            org.jfrog.hudson.release.promotion.PromotionConfig promotionConfig = Utils.convertPromotionConfig(pipelinePromotionConfig);
            List list = this.build.getAllActions();
            synchronized (list) {
                UnifiedPromoteBuildAction action = (UnifiedPromoteBuildAction)this.build.getAction(UnifiedPromoteBuildAction.class);
                if (action == null) {
                    action = new UnifiedPromoteBuildAction((Run<?, ?>)this.build);
                    this.build.addAction((Action)action);
                }
                action.addPromotionCandidate(promotionConfig, configurator, this.step.displayName);
            }
        }
    }
}

