/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.conan;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.ConanExecutor;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConanClientStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtConanClient";
    private final BuildDataFile buildDataFile;
    private String userHome;

    @DataBoundConstructor
    public ConanClientStep(String id) {
        this.buildDataFile = new BuildDataFile(STEP_NAME, id);
    }

    @DataBoundSetter
    public void setUserHome(String userHome) {
        this.userHome = userHome;
        this.buildDataFile.put("userHome", userHome);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return ConanClientStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Creates new Conan client";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient ConanClientStep step;

        @Inject
        public Execution(ConanClientStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            FilePath conanHomeDirectory = Utils.getConanHomeDirectory(this.step.userHome, this.env, this.launcher, this.ws);
            this.step.setUserHome(conanHomeDirectory.getRemote());
            ConanExecutor conanExecutor = new ConanExecutor(conanHomeDirectory.getRemote(), this.ws, this.launcher, this.listener, this.env, (Run)this.build);
            conanExecutor.execClientInit();
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build);
            DeclarativePipelineUtils.writeBuildDataFile(this.rootWs, buildNumber, this.step.buildDataFile, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }
    }
}

