/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.conan;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.ConanExecutor;
import org.jfrog.hudson.pipeline.common.types.ConanClient;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ConanRemoteStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtConanRemote";
    private final String clientId;
    private final String name;
    private final String serverId;
    private final String repo;
    private boolean force;
    private boolean verifySSL = true;

    @DataBoundConstructor
    public ConanRemoteStep(String clientId, String name, String serverId, String repo) {
        this.clientId = clientId;
        this.name = name;
        this.serverId = serverId;
        this.repo = repo;
    }

    @DataBoundSetter
    public void setForce(boolean force) {
        this.force = force;
    }

    @DataBoundSetter
    public void setVerifySSL(boolean verifySSL) {
        this.verifySSL = verifySSL;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getRepo() {
        return this.repo;
    }

    public boolean getForce() {
        return this.force;
    }

    public boolean getVerifySSL() {
        return this.verifySSL;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return ConanRemoteStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Add new repo to Conan config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient ConanRemoteStep step;

        @Inject
        public Execution(ConanRemoteStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build);
            ConanClient conanClient = DeclarativePipelineUtils.buildConanClient(this.step.getClientId(), buildNumber, "rtConanClient", this.launcher, this.ws, this.rootWs, this.env);
            ConanExecutor conanExecutor = new ConanExecutor(conanClient.getUserPath(), this.ws, this.launcher, this.listener, this.env, (Run)this.build);
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            String serverUrl = Utils.buildConanRemoteUrl(server, this.step.getRepo());
            conanExecutor.execRemoteAdd(this.step.getName(), serverUrl, this.step.getForce(), this.step.getVerifySSL());
            ArtifactoryServer artifactoryServer = Utils.prepareArtifactoryServer(null, server);
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(artifactoryServer);
            CredentialsConfig deployerConfig = CredentialManager.getPreferredDeployer(configurator, artifactoryServer);
            String username = deployerConfig.provideCredentials((Item)this.build.getParent()).getUsername();
            String password = deployerConfig.provideCredentials((Item)this.build.getParent()).getPassword();
            conanExecutor.execUserAdd(username, password, this.step.getName());
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            return Utils.prepareArtifactoryServer(null, server);
        }

        @Override
        public String getUsageReportFeatureName() {
            return ConanRemoteStep.STEP_NAME;
        }
    }
}

