/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.distribution;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ReleaseBundleSignExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SignReleaseBundleStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "dsSignReleaseBundle";
    private final String serverId;
    private final String version;
    private final String name;
    private String gpgPassphrase;
    private String storingRepo;

    @DataBoundConstructor
    public SignReleaseBundleStep(String serverId, String name, String version) {
        this.serverId = serverId;
        this.name = name;
        this.version = version;
    }

    @DataBoundSetter
    public void setGpgPassphrase(String gpgPassphrase) {
        this.gpgPassphrase = gpgPassphrase;
    }

    @DataBoundSetter
    public void setStoringRepo(String storingRepo) {
        this.storingRepo = storingRepo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return SignReleaseBundleStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Sign a release bundle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Void> {
        private final transient SignReleaseBundleStep step;

        @Inject
        public Execution(SignReleaseBundleStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            DistributionServer server = DeclarativePipelineUtils.getDistributionServer(this.build, this.rootWs, this.step.serverId, true);
            new ReleaseBundleSignExecutor(server, this.step.name, this.step.version, this.step.gpgPassphrase, this.step.storingRepo, this.listener, (Run<?, ?>)this.build, this.ws).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws Exception {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return SignReleaseBundleStep.STEP_NAME;
        }
    }
}

