/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.generic;

import com.google.inject.Inject;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.SpecConfiguration;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.EditPropsExecutor;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.SpecUtils;
import org.kohsuke.stapler.DataBoundSetter;

public class EditPropsStep
extends AbstractStepImpl {
    private final EditPropertiesHelper.EditPropertiesActionType editType;
    protected String serverId;
    protected String spec;
    private String props;
    private String specPath;
    private boolean failNoOp;

    EditPropsStep(String serverId, EditPropertiesHelper.EditPropertiesActionType editType) {
        this.serverId = serverId;
        this.editType = editType;
    }

    @DataBoundSetter
    public void setSpec(String spec) {
        this.spec = spec;
    }

    @DataBoundSetter
    public void setSpecPath(String specPath) {
        this.specPath = specPath;
    }

    @DataBoundSetter
    public void setProps(String props) {
        this.props = props;
    }

    @DataBoundSetter
    public void setFailNoOp(boolean failNoOp) {
        this.failNoOp = failNoOp;
    }

    public static abstract class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected transient EditPropsStep step;
        protected ArtifactoryServer artifactoryServer;
        protected String spec;

        @Inject
        public Execution(EditPropsStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(this.step.serverId, null);
        }

        void editPropsRun() throws IOException, InterruptedException {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            this.artifactoryServer = Utils.prepareArtifactoryServer(null, pipelineServer);
            SpecConfiguration specConfiguration = new SpecConfiguration(this.step.spec, this.step.specPath);
            this.spec = SpecUtils.getSpecStringFromSpecConf(specConfiguration, this.env, this.ws, this.listener.getLogger());
            EditPropsExecutor editPropsExecutor = new EditPropsExecutor(this.artifactoryServer, this.listener, (Run)this.build, this.ws, this.spec, this.step.editType, this.step.props, this.step.failNoOp);
            editPropsExecutor.execute();
        }
    }
}

