/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.go;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.GoPublishExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.GoBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.CommonDeployer;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.PropertyUtils;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GoPublishStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtGoPublish";
    private final GoBuild goBuild = new GoBuild();
    private String customBuildNumber;
    private String customBuildName;
    private String project;
    private String deployerId;
    private String javaArgs;
    private String path;
    private String module;
    private String version;

    @DataBoundConstructor
    public GoPublishStep() {
    }

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setProject(String customProject) {
        this.project = customProject;
    }

    @DataBoundSetter
    public void setDeployerId(String deployerId) {
        this.deployerId = deployerId;
    }

    @DataBoundSetter
    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    @DataBoundSetter
    public void setModule(String module) {
        this.module = module;
    }

    @DataBoundSetter
    public void setVersion(String version) {
        this.version = version;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return GoPublishStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory Go publish";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient GoPublishStep step;

        @Inject
        public Execution(GoPublishStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.customBuildName, this.step.customBuildNumber, this.step.project);
            this.setDeployer(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            GoPublishExecutor goPublishExecutor = new GoPublishExecutor(this.listener, buildInfo, this.launcher, this.step.goBuild, this.step.javaArgs, this.step.path, this.step.module, this.ws, this.env, (Run<?, ?>)this.build, this.step.version);
            goPublishExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(goPublishExecutor.getBuildInfo(), this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            CommonDeployer resolver = this.getDeployer(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return GoPublishStep.STEP_NAME;
        }

        private CommonDeployer getDeployer(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((CharSequence)this.step.deployerId)) {
                return null;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtGoDeployer", this.step.deployerId);
            if (buildDataFile == null) {
                throw new IOException("Deployer " + this.step.deployerId + " doesn't exist!");
            }
            return (CommonDeployer)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtGoDeployer"), CommonDeployer.class);
        }

        private void setDeployer(String buildNumber) throws IOException, InterruptedException {
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtGoDeployer", this.step.deployerId);
            CommonDeployer deployer = this.getDeployer(buildNumber);
            deployer.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.goBuild.setDeployer(deployer);
            this.addProperties(buildDataFile);
        }

        private void addProperties(BuildDataFile buildDataFile) {
            JsonNode propertiesNode = buildDataFile.get("properties");
            if (propertiesNode != null) {
                this.step.goBuild.getDeployer().getProperties().putAll(PropertyUtils.getDeploymentPropertiesMap(propertiesNode.asText(), this.env));
            }
        }

        private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getArtifactoryServer(String buildNumber, BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, serverId.asText(), true);
        }
    }
}

