/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.npm;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.NpmInstallCiExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.NpmBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class NpmInstallCiStepBase
extends AbstractStepImpl {
    private final NpmBuild npmBuild = new NpmBuild();
    private String customBuildNumber;
    private String customBuildName;
    private String project;
    private String resolverId;
    private String javaArgs;
    private String path;
    private String args;
    private String module;
    protected boolean ciCommand;

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setProject(String customProject) {
        this.project = customProject;
    }

    @DataBoundSetter
    public void setResolverId(String resolverId) {
        this.resolverId = resolverId;
    }

    @DataBoundSetter
    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    @DataBoundSetter
    public void setModule(String module) {
        this.module = module;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = args;
    }

    @DataBoundSetter
    public void setTool(String tool) {
        this.npmBuild.setTool(tool);
    }

    public abstract String getUsageReportFeatureName();

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private transient NpmInstallCiStepBase step;

        @Inject
        public Execution(NpmInstallCiStepBase step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.customBuildName, this.step.customBuildNumber, this.step.project);
            CommonResolver resolver = this.getResolver(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            this.step.npmBuild.setResolver(resolver);
            Utils.addNpmToPath(this.ws, this.listener, this.env, this.launcher, this.step.npmBuild.getTool());
            NpmInstallCiExecutor npmInstallCiExecutor = new NpmInstallCiExecutor(buildInfo, this.launcher, this.step.npmBuild, this.step.javaArgs, this.step.args, this.ws, this.step.path, this.step.module, this.env, this.listener, (Run)this.build, this.step.ciCommand);
            npmInstallCiExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(npmInstallCiExecutor.getBuildInfo(), this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return this.step.getUsageReportFeatureName();
        }

        private CommonResolver getResolver(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((CharSequence)this.step.resolverId)) {
                return null;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtNpmResolver", this.step.resolverId);
            if (buildDataFile == null) {
                throw new IOException("Resolver " + this.step.resolverId + " doesn't exist!");
            }
            CommonResolver resolver = (CommonResolver)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtNpmResolver"), CommonResolver.class);
            resolver.setServer(this.getArtifactoryServer(buildDataFile));
            return resolver;
        }

        private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getArtifactoryServer(BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, serverId.asText(), true);
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            CommonResolver resolver = this.getResolver(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }
    }
}

