/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.npm;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.NpmPublishExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.NpmBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.CommonDeployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.PropertyUtils;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NpmPublishStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtNpmPublish";
    private final NpmBuild npmBuild = new NpmBuild();
    private String customBuildNumber;
    private String customBuildName;
    private String project;
    private String deployerId;
    private String javaArgs;
    private String path;
    private String module;

    @DataBoundConstructor
    public NpmPublishStep() {
    }

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setProject(String customProject) {
        this.project = customProject;
    }

    @DataBoundSetter
    public void setDeployerId(String deployerId) {
        this.deployerId = deployerId;
    }

    @DataBoundSetter
    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    @DataBoundSetter
    public void setModule(String module) {
        this.module = module;
    }

    @DataBoundSetter
    public void setTool(String tool) {
        this.npmBuild.setTool(tool);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return NpmPublishStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory npm publish";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient NpmPublishStep step;

        @Inject
        public Execution(NpmPublishStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.customBuildName, this.step.customBuildNumber, this.step.project);
            this.setDeployer(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            Utils.addNpmToPath(this.ws, this.listener, this.env, this.launcher, this.step.npmBuild.getTool());
            NpmPublishExecutor npmPublishExecutor = new NpmPublishExecutor(this.listener, buildInfo, this.launcher, this.step.npmBuild, this.step.javaArgs, this.step.path, this.step.module, this.ws, this.env, (Run)this.build);
            npmPublishExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(npmPublishExecutor.getBuildInfo(), this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            this.setDeployer(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            Resolver resolver = this.step.npmBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return NpmPublishStep.STEP_NAME;
        }

        private void setDeployer(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((CharSequence)this.step.deployerId)) {
                return;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtNpmDeployer", this.step.deployerId);
            if (buildDataFile == null) {
                throw new IOException("Deployer " + this.step.deployerId + " doesn't exist!");
            }
            CommonDeployer deployer = (CommonDeployer)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtNpmDeployer"), CommonDeployer.class);
            deployer.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.npmBuild.setDeployer(deployer);
            this.addProperties(buildDataFile);
        }

        private void addProperties(BuildDataFile buildDataFile) {
            JsonNode propertiesNode = buildDataFile.get("properties");
            if (propertiesNode != null) {
                this.step.npmBuild.getDeployer().getProperties().putAll(PropertyUtils.getDeploymentPropertiesMap(propertiesNode.asText(), this.env));
            }
        }

        private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getArtifactoryServer(String buildNumber, BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, serverId.asText(), true);
        }
    }
}

