/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.xray;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.XrayExecutor;
import org.jfrog.hudson.pipeline.common.types.XrayScanConfig;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class XrayScanStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "xrayScan";
    private final XrayScanConfig xrayScanConfig;
    private final String serverId;

    @DataBoundConstructor
    public XrayScanStep(String serverId) {
        this.serverId = serverId;
        this.xrayScanConfig = new XrayScanConfig();
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.xrayScanConfig.setBuildName(buildName);
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.xrayScanConfig.setBuildNumber(buildNumber);
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.xrayScanConfig.setProject(project);
    }

    @DataBoundSetter
    public void setFailBuild(boolean failBuild) {
        this.xrayScanConfig.setFailBuild(failBuild);
    }

    @DataBoundSetter
    public void setPrintTable(boolean printTable) {
        this.xrayScanConfig.setPrintTable(printTable);
    }

    private XrayScanConfig prepareXrayScanConfig(Run<?, ?> build) {
        if (StringUtils.isBlank((CharSequence)this.xrayScanConfig.getBuildName())) {
            this.xrayScanConfig.setBuildName(BuildUniqueIdentifierHelper.getBuildName(build));
        }
        if (StringUtils.isBlank((CharSequence)this.xrayScanConfig.getBuildNumber())) {
            this.xrayScanConfig.setBuildNumber(BuildUniqueIdentifierHelper.getBuildNumber(build));
        }
        return this.xrayScanConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return XrayScanStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Xray scan";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient XrayScanStep step;

        @Inject
        public Execution(XrayScanStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            XrayScanConfig xrayScanConfig = this.step.prepareXrayScanConfig((Run)this.build);
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            XrayExecutor xrayExecutor = new XrayExecutor(xrayScanConfig, this.listener, server, (Run<?, ?>)this.build);
            xrayExecutor.execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            return Utils.prepareArtifactoryServer(null, server);
        }

        @Override
        public String getUsageReportFeatureName() {
            return XrayScanStep.STEP_NAME;
        }
    }
}

