/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.dsl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance;

public class JFrogPipelineGlobal
implements Serializable {
    private static final String CREDENTIALS_ID = "credentialsId";
    private static final String DS_URL = "distributionUrl";
    private static final String RT_URL = "artifactoryUrl";
    private static final String PASSWORD = "password";
    private static final String USERNAME = "username";
    private static final String URL = "url";
    private final CpsScript cpsScript;

    public JFrogPipelineGlobal(CpsScript script) {
        this.cpsScript = script;
    }

    @Whitelisted
    public JFrogPlatformInstance instance(String instanceId) {
        LinkedHashMap<String, String> stepVariables = new LinkedHashMap<String, String>();
        stepVariables.put("instanceId", instanceId);
        JFrogPlatformInstance instance = (JFrogPlatformInstance)this.cpsScript.invokeMethod("getJFrogPlatformInstance", stepVariables);
        instance.setCpsScript(this.cpsScript);
        return instance;
    }

    @Whitelisted
    public JFrogPlatformInstance newInstance(Map<String, Object> stepVariables) {
        JFrogPlatformInstance instance = (JFrogPlatformInstance)this.cpsScript.invokeMethod("newJFrogPlatformInstance", stepVariables);
        instance.setCpsScript(this.cpsScript);
        return instance;
    }

    @Whitelisted
    public JFrogPlatformInstance newInstance(String url, String artifactoryUrl, String distributionUrl, String username, String password) {
        return this.newInstance(this.createInstanceParams(url, artifactoryUrl, distributionUrl, username, password, ""));
    }

    @Whitelisted
    public JFrogPlatformInstance newInstance(String url, String artifactoryUrl, String distributionUrl, String credentialsId) {
        return this.newInstance(this.createInstanceParams(url, artifactoryUrl, distributionUrl, "", "", credentialsId));
    }

    private Map<String, Object> createInstanceParams(final String url, final String artifactoryUrl, final String distributionUrl, final String username, final String password, final String credentialsId) {
        return new HashMap<String, Object>(){
            {
                this.put(JFrogPipelineGlobal.URL, url);
                this.put(JFrogPipelineGlobal.RT_URL, artifactoryUrl);
                this.put(JFrogPipelineGlobal.DS_URL, distributionUrl);
                this.put(JFrogPipelineGlobal.USERNAME, username);
                this.put(JFrogPipelineGlobal.PASSWORD, password);
                this.put(JFrogPipelineGlobal.CREDENTIALS_ID, credentialsId);
            }
        };
    }
}

