/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddInteractivePromotionStep
extends AbstractStepImpl {
    static final String STEP_NAME = "addInteractivePromotion";
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private PromotionConfig promotionConfig;
    private String displayName;

    @DataBoundConstructor
    public AddInteractivePromotionStep(PromotionConfig promotionConfig, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String displayName) {
        this.promotionConfig = promotionConfig;
        this.server = server;
        this.displayName = displayName;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public PromotionConfig getPromotionConfig() {
        return this.promotionConfig;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return AddInteractivePromotionStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Add interactive promotion";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Boolean> {
        private transient AddInteractivePromotionStep step;

        @Inject
        public Execution(AddInteractivePromotionStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(Utils.prepareArtifactoryServer(null, this.step.getServer()));
            this.addPromotionAction(configurator);
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return AddInteractivePromotionStep.STEP_NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPromotionAction(ArtifactoryConfigurator configurator) {
            PromotionConfig pipelinePromotionConfig = this.step.getPromotionConfig();
            org.jfrog.hudson.release.promotion.PromotionConfig promotionConfig = Utils.convertPromotionConfig(pipelinePromotionConfig);
            List list = this.build.getAllActions();
            synchronized (list) {
                UnifiedPromoteBuildAction action = (UnifiedPromoteBuildAction)this.build.getAction(UnifiedPromoteBuildAction.class);
                if (action == null) {
                    action = new UnifiedPromoteBuildAction((Run<?, ?>)this.build);
                    this.build.addAction((Action)action);
                }
                action.addPromotionCandidate(promotionConfig, configurator, this.step.getDisplayName());
            }
        }
    }
}

