/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.CollectIssuesExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Issues;
import org.kohsuke.stapler.DataBoundConstructor;

public class CollectIssuesStep
extends AbstractStepImpl {
    static final String STEP_NAME = "collectIssues";
    private Issues issues;
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private String config;

    @DataBoundConstructor
    public CollectIssuesStep(Issues issues, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String config) {
        this.issues = issues;
        this.server = server;
        this.config = config;
    }

    public Issues getIssues() {
        return this.issues;
    }

    public String getConfig() {
        return this.config;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CollectIssuesStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Collect issues from git and add them to a build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Boolean> {
        private transient CollectIssuesStep step;

        @Inject
        public Execution(CollectIssuesStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        @Whitelisted
        protected Boolean runStep() throws Exception {
            CollectIssuesExecutor collectIssuesExecutor = new CollectIssuesExecutor((Run)this.build, this.listener, this.ws, this.step.getIssues().getBuildName(), this.step.getConfig(), this.step.getIssues(), this.step.getServer(), this.step.getIssues().getProject());
            collectIssuesExecutor.execute();
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return CollectIssuesStep.STEP_NAME;
        }
    }
}

