/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateArtifactoryServerStep
extends AbstractStepImpl {
    private String url;
    private String username;
    private String password;
    private String credentialsId;

    @DataBoundConstructor
    public CreateArtifactoryServerStep(String url, String username, String password, String credentialsId) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.credentialsId = credentialsId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "newArtifactoryServer";
        }

        public String getDisplayName() {
            return "Returns new Artifactory server";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends SynchronousStepExecution<ArtifactoryServer> {
        private static final long serialVersionUID = 1L;
        private transient CreateArtifactoryServerStep step;

        @Inject
        public Execution(CreateArtifactoryServerStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected ArtifactoryServer run() throws Exception {
            String artifactoryUrl = this.step.getUrl();
            if (StringUtils.isEmpty((CharSequence)artifactoryUrl)) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Artifactory server URL is mandatory"));
            }
            if (!StringUtils.isEmpty((CharSequence)this.step.getCredentialsId())) {
                return new ArtifactoryServer(artifactoryUrl, this.step.getCredentialsId());
            }
            return new ArtifactoryServer(artifactoryUrl, this.step.getUsername(), this.step.getPassword());
        }
    }
}

