/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.DockerPullExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPullStep
extends AbstractStepImpl {
    static final String STEP_NAME = "dockerPullStep";
    private final String image;
    private final org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private final BuildInfo buildInfo;
    private final String host;
    private final String javaArgs;
    private String sourceRepo;

    @DataBoundConstructor
    public DockerPullStep(String image, String host, String sourceRepo, String javaArgs, BuildInfo buildInfo, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
        this.image = image;
        this.host = host;
        this.buildInfo = buildInfo;
        this.server = server;
        this.javaArgs = javaArgs;
        this.sourceRepo = sourceRepo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getImage() {
        return this.image;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public String getSourceRepo() {
        return this.sourceRepo;
    }

    public String getHost() {
        return this.host;
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DockerPullStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Artifactory docker pull";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        private final transient DockerPullStep step;

        @Inject
        public Execution(DockerPullStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            if (this.step.getImage() == null) {
                this.getContext().onFailure((Throwable)new AbortException("Missing 'image' parameter"));
                return null;
            }
            if (this.step.getSourceRepo() == null) {
                this.getContext().onFailure((Throwable)new AbortException("Missing 'sourceRepo' parameter"));
                return null;
            }
            BuildInfo buildInfo = Utils.prepareBuildinfo((Run)this.build, this.step.getBuildInfo());
            String imageTag = this.step.getImage();
            if (!DockerUtils.isImageVersioned((String)imageTag).booleanValue()) {
                imageTag = imageTag + ":latest";
            }
            DockerPullExecutor dockerExecutor = new DockerPullExecutor(this.step.getServer(), buildInfo, (Run<?, ?>)this.build, this.step.image, this.step.sourceRepo, this.step.host, this.step.javaArgs, this.launcher, this.listener, this.ws, this.env);
            dockerExecutor.execute();
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            log.info("Successfully pulled docker image: " + imageTag);
            return dockerExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(null, this.step.getServer());
        }

        @Override
        public String getUsageReportFeatureName() {
            return DockerPullStep.STEP_NAME;
        }
    }
}

