/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.GetJFrogPlatformInstancesExecutor;
import org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetJFrogPlatformInstanceStep
extends AbstractStepImpl {
    static final String STEP_NAME = "getJFrogPlatformInstance";
    private final String instanceId;

    @DataBoundConstructor
    public GetJFrogPlatformInstanceStep(String instanceId) {
        this.instanceId = instanceId;
    }

    private String getInstanceId() {
        return this.instanceId;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return GetJFrogPlatformInstanceStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Get JFrog Platform instance from Jenkins config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<JFrogPlatformInstance> {
        private final transient GetJFrogPlatformInstanceStep step;

        @Inject
        public Execution(GetJFrogPlatformInstanceStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected JFrogPlatformInstance runStep() throws Exception {
            String jfrogPlatformInstanceID = this.step.getInstanceId();
            GetJFrogPlatformInstancesExecutor getArtifactoryServerExecutor = new GetJFrogPlatformInstancesExecutor((Run<?, ?>)this.build, jfrogPlatformInstanceID);
            getArtifactoryServerExecutor.execute();
            return getArtifactoryServerExecutor.getJFrogPlatformInstance();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(this.step.getInstanceId(), null);
        }

        @Override
        public String getUsageReportFeatureName() {
            return GetJFrogPlatformInstanceStep.STEP_NAME;
        }
    }
}

