/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.GoPublishExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.GoBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.kohsuke.stapler.DataBoundConstructor;

public class GoPublishStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryGoPublish";
    private BuildInfo buildInfo;
    private GoBuild goBuild;
    private String path;
    private String version;
    private String module;
    private String javaArgs;

    @DataBoundConstructor
    public GoPublishStep(BuildInfo buildInfo, GoBuild goBuild, String path, String version, String args, String module, String javaArgs) {
        this.buildInfo = buildInfo;
        this.goBuild = goBuild;
        this.path = path;
        this.version = version;
        this.module = module;
        this.javaArgs = javaArgs;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return GoPublishStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Run Artifactory Go Publish command";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        private transient GoPublishStep step;

        @Inject
        public Execution(GoPublishStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            GoPublishExecutor goPublishExecutor = new GoPublishExecutor(this.listener, this.step.buildInfo, this.launcher, this.step.goBuild, this.step.javaArgs, this.step.path, this.step.module, this.ws, this.env, (Run<?, ?>)this.build, this.step.version);
            goPublishExecutor.execute();
            return goPublishExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Deployer deployer = this.step.goBuild.getDeployer();
            if (deployer != null) {
                return deployer.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return GoPublishStep.STEP_NAME;
        }
    }
}

