/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.GoRunExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.GoBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class GoRunStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryGoRun";
    private BuildInfo buildInfo;
    private GoBuild goBuild;
    private String path;
    private String goCmdArgs;
    private String module;
    private String javaArgs;

    @DataBoundConstructor
    public GoRunStep(BuildInfo buildInfo, GoBuild goBuild, String path, String goCmdArgs, String args, String module, String javaArgs) {
        this.buildInfo = buildInfo;
        this.goBuild = goBuild;
        this.path = path;
        this.goCmdArgs = goCmdArgs;
        this.module = module;
        this.javaArgs = javaArgs;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return GoRunStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Run Artifactory Go command";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        private transient GoRunStep step;

        @Inject
        public Execution(GoRunStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            GoRunExecutor goRunExecutor = new GoRunExecutor(this.step.buildInfo, this.launcher, this.step.goBuild, this.step.javaArgs, this.step.goCmdArgs, this.ws, this.step.path, this.step.module, this.env, this.listener, (Run)this.build);
            goRunExecutor.execute();
            return goRunExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Resolver resolver = this.step.goBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return GoRunStep.STEP_NAME;
        }
    }
}

