/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.NugetRunExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.NugetBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.Resolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class NugetRunStep
extends AbstractStepImpl {
    static final String STEP_NAME = "artifactoryNugetRun";
    private BuildInfo buildInfo;
    private NugetBuild nugetBuild;
    private String javaArgs;
    private String args;
    private String module;

    @DataBoundConstructor
    public NugetRunStep(BuildInfo buildInfo, NugetBuild nugetBuild, String javaArgs, String args, String module) {
        this.buildInfo = buildInfo;
        this.nugetBuild = nugetBuild;
        this.javaArgs = javaArgs;
        this.args = args;
        this.module = module;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return NugetRunStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Run Artifactory NuGet";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<BuildInfo> {
        private transient NugetRunStep step;

        @Inject
        public Execution(NugetRunStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected BuildInfo runStep() throws Exception {
            NugetRunExecutor nugetRunExecutor = new NugetRunExecutor(this.step.buildInfo, this.launcher, this.step.nugetBuild, this.step.javaArgs, this.step.args, this.ws, this.step.module, this.env, this.listener, (Run)this.build);
            nugetRunExecutor.execute();
            return nugetRunExecutor.getBuildInfo();
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            Resolver resolver = this.step.nugetBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return NugetRunStep.STEP_NAME;
        }
    }
}

