/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.conan;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ConanExecutor;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddRemoteStep
extends AbstractStepImpl {
    static final String STEP_NAME = "conanAddRemote";
    private String serverUrl;
    private String serverName;
    private String conanHome;
    private boolean force;
    private boolean verifySSL;

    @DataBoundConstructor
    public AddRemoteStep(String serverUrl, String serverName, String conanHome, boolean force, boolean verifySSL) {
        this.serverUrl = serverUrl;
        this.serverName = serverName;
        this.conanHome = conanHome;
        this.force = force;
        this.verifySSL = verifySSL;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getConanHome() {
        return this.conanHome;
    }

    public boolean getForce() {
        return this.force;
    }

    public boolean getVerifySSL() {
        return this.verifySSL;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return AddRemoteStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Add new repo to Conan config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Boolean> {
        private transient AddRemoteStep step;

        @Inject
        public Execution(AddRemoteStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Boolean runStep() throws Exception {
            ConanExecutor conanExecutor = new ConanExecutor(this.step.getConanHome(), this.ws, this.launcher, this.listener, this.env, (Run)this.build);
            conanExecutor.execRemoteAdd(this.step.getServerName(), this.step.getServerUrl(), this.step.getForce(), this.step.getVerifySSL());
            return true;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }
    }
}

