/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.distribution;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ReleaseBundleCreateExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.scripted.steps.distribution.CreateUpdateReleaseBundleStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class CreateReleaseBundleStep
extends CreateUpdateReleaseBundleStep {
    static final String STEP_NAME = "createReleaseBundle";

    @DataBoundConstructor
    public CreateReleaseBundleStep(DistributionServer server, String name, String version, String spec, String storingRepo, boolean signImmediately, boolean dryRun, String gpgPassphrase, String releaseNotesPath, String releaseNotesSyntax, String description) {
        super(server, name, version, spec, storingRepo, signImmediately, dryRun, gpgPassphrase, releaseNotesPath, releaseNotesSyntax, description);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CreateReleaseBundleStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Create a release bundle ";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient CreateReleaseBundleStep step;

        @Inject
        public Execution(CreateReleaseBundleStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            new ReleaseBundleCreateExecutor(this.step.getServer(), this.step.name, this.step.version, this.step.getSpec(), this.step.storingRepo, this.step.signImmediately, this.step.dryRun, this.step.gpgPassphrase, this.step.releaseNotesPath, this.step.releaseNotesSyntax, this.step.description, this.listener, (Run<?, ?>)this.build, this.ws, this.env).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return CreateReleaseBundleStep.STEP_NAME;
        }
    }
}

