/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.distribution;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ReleaseBundleDistributeExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.scripted.steps.distribution.RemoteReleaseBundleStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class DistributeReleaseBundleStep
extends RemoteReleaseBundleStep {
    static final String STEP_NAME = "distributeReleaseBundle";

    @DataBoundConstructor
    public DistributeReleaseBundleStep(DistributionServer server, String name, String version, boolean dryRun, boolean sync, String distRules, List<String> countryCodes, String siteName, String cityName) {
        super(server, name, version, dryRun, sync, distRules, countryCodes, siteName, cityName);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DistributeReleaseBundleStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Distribute a release bundle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        private final transient DistributeReleaseBundleStep step;

        @Inject
        public Execution(DistributeReleaseBundleStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            new ReleaseBundleDistributeExecutor(this.step.getServer(), this.step.name, this.step.version, this.step.dryRun, this.step.sync, this.step.distRules, this.step.countryCodes, this.step.siteName, this.step.cityName, this.listener, (Run<?, ?>)this.build, this.ws).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return DistributeReleaseBundleStep.STEP_NAME;
        }
    }
}

