/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release;

import hudson.model.TaskListener;
import java.io.IOException;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;

public class PromotionUtils {
    public static boolean promoteAndCheckResponse(Promotion promotion, ArtifactoryManager artifactoryManager, TaskListener listener, String buildName, String buildNumber, String project) throws IOException {
        if (promotion.isFailFast()) {
            promotion.setDryRun(true);
            listener.getLogger().println("Performing dry run promotion (no changes are made during dry run) ...");
            try {
                artifactoryManager.stageBuild(buildName, buildNumber, project, promotion);
                listener.getLogger().println("Dry run finished successfully.\nPerforming promotion ...");
            }
            catch (IOException e) {
                PromotionUtils.onPromotionFailFast(true, promotion.isFailFast());
                return false;
            }
        }
        promotion.setDryRun(false);
        try {
            artifactoryManager.stageBuild(buildName, buildNumber, project, promotion);
        }
        catch (IOException e) {
            listener.error(e.getMessage());
            return false;
        }
        listener.getLogger().println("Promotion completed successfully!");
        return true;
    }

    public static void onPromotionFailFast(boolean dryRun, boolean failFast) throws IOException {
        if (failFast) {
            if (dryRun) {
                throw new IOException("Promotion failed during dry run (no change in Artifactory was done).");
            }
            throw new IOException("Promotion failed. View Artifactory logs for more details.");
        }
    }
}

