/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.gradle;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.gradle.BaseGradleReleaseAction;
import org.jfrog.hudson.release.gradle.GradlePropertiesTransformer;
import org.jfrog.hudson.release.gradle.GradleReleaseAction;
import org.jfrog.hudson.release.gradle.GradleReleaseApiAction;
import org.jfrog.hudson.release.scm.AbstractScmCoordinator;
import org.jfrog.hudson.release.scm.ScmCoordinator;
import org.jfrog.hudson.release.scm.git.GitCoordinator;
import org.kohsuke.stapler.DataBoundConstructor;

public class GradleReleaseWrapper {
    private static final Logger debuggingLogger = Logger.getLogger(GradleReleaseWrapper.class.getName());
    private String tagPrefix;
    private String releaseBranchPrefix;
    private String targetRemoteName;
    private String alternativeTasks;
    private String releasePropsKeys;
    private String nextIntegPropsKeys;
    private String defaultReleaseStagingRepository;
    private transient ScmCoordinator scmCoordinator;
    private boolean useReleaseBranch;

    @DataBoundConstructor
    public GradleReleaseWrapper(String releaseBranchPrefix, String tagPrefix, String targetRemoteName, String alternativeTasks, String releasePropsKeys, String nextIntegPropsKeys, String defaultReleaseStagingRepository, boolean useReleaseBranch) {
        this.releaseBranchPrefix = releaseBranchPrefix;
        this.tagPrefix = tagPrefix;
        this.targetRemoteName = targetRemoteName;
        this.alternativeTasks = alternativeTasks;
        this.releasePropsKeys = releasePropsKeys;
        this.nextIntegPropsKeys = nextIntegPropsKeys;
        this.defaultReleaseStagingRepository = defaultReleaseStagingRepository;
        this.useReleaseBranch = useReleaseBranch;
    }

    public ScmCoordinator getScmCoordinator() {
        return this.scmCoordinator;
    }

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    public String getTargetRemoteName() {
        return this.targetRemoteName;
    }

    public void setTargetRemoteName(String targetRemoteName) {
        this.targetRemoteName = targetRemoteName;
    }

    public String getReleasePropsKeys() {
        return this.releasePropsKeys;
    }

    public void setReleasePropsKeys(String releasePropsKeys) {
        this.releasePropsKeys = releasePropsKeys;
    }

    public String getNextIntegPropsKeys() {
        return this.nextIntegPropsKeys;
    }

    public void setNextIntegPropsKeys(String nextIntegPropsKeys) {
        this.nextIntegPropsKeys = nextIntegPropsKeys;
    }

    public String getReleaseBranchPrefix() {
        return this.releaseBranchPrefix;
    }

    public void setReleaseBranchPrefix(String releaseBranchPrefix) {
        this.releaseBranchPrefix = releaseBranchPrefix;
    }

    public String getAlternativeTasks() {
        return this.alternativeTasks;
    }

    public void setAlternativeTasks(String alternativeTasks) {
        this.alternativeTasks = alternativeTasks;
    }

    public String getDefaultReleaseStagingRepository() {
        return this.defaultReleaseStagingRepository;
    }

    public void setDefaultReleaseStagingRepository(String defaultReleaseStagingRepository) {
        this.defaultReleaseStagingRepository = defaultReleaseStagingRepository;
    }

    public boolean isUseReleaseBranch() {
        return this.useReleaseBranch;
    }

    public void setUseReleaseBranch(boolean useReleaseBranch) {
        this.useReleaseBranch = useReleaseBranch;
    }

    public String[] getReleasePropsKeysList() {
        return this.stringToArray(this.getReleasePropsKeys());
    }

    public String[] getNextIntegPropsKeysList() {
        return this.stringToArray(this.getNextIntegPropsKeys());
    }

    private String[] stringToArray(String commaSeparatedString) {
        commaSeparatedString = StringUtils.trimToEmpty((String)commaSeparatedString);
        return StringUtils.split((String)commaSeparatedString, (String)", ");
    }

    public void setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        BaseGradleReleaseAction releaseAction = (BaseGradleReleaseAction)build.getAction(GradleReleaseAction.class);
        if (releaseAction == null) {
            releaseAction = (BaseGradleReleaseAction)build.getAction(GradleReleaseApiAction.class);
        }
        if (releaseAction == null) {
            return;
        }
        this.log(listener, "Release build triggered");
        this.scmCoordinator = AbstractScmCoordinator.createScmCoordinator(build, listener, releaseAction);
        this.scmCoordinator.prepare();
        if (!releaseAction.getVersioning().equals((Object)ReleaseAction.VERSIONING.NONE)) {
            if (this.scmCoordinator instanceof GitCoordinator) {
                try {
                    ((GitCoordinator)this.scmCoordinator).pushDryRun();
                }
                catch (Exception e) {
                    this.log(listener, "ERROR: " + e.getMessage());
                    throw new Run.RunnerAbortedException();
                }
            }
            this.scmCoordinator.beforeReleaseVersionChange();
            boolean modified = this.changeProperties(build, releaseAction, true, listener);
            this.scmCoordinator.afterReleaseVersionChange(modified);
        }
    }

    public boolean tearDown(AbstractBuild build, BuildListener listener) {
        Result result = build.getResult();
        if (result == null || result.isWorseThan(Result.SUCCESS)) {
            return true;
        }
        BaseGradleReleaseAction releaseAction = (BaseGradleReleaseAction)build.getAction(GradleReleaseAction.class);
        if (releaseAction == null) {
            releaseAction = (BaseGradleReleaseAction)build.getAction(GradleReleaseApiAction.class);
        }
        try {
            this.scmCoordinator.afterSuccessfulReleaseVersionBuild();
            if (!releaseAction.getVersioning().equals((Object)ReleaseAction.VERSIONING.NONE)) {
                this.scmCoordinator.beforeDevelopmentVersionChange();
                boolean modified = this.changeProperties(build, releaseAction, false, listener);
                this.scmCoordinator.afterDevelopmentVersionChange(modified);
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Failure in post build SCM action: " + e.getMessage());
            debuggingLogger.log(Level.FINE, "Failure in post build SCM action: ", e);
            return false;
        }
        return true;
    }

    private boolean changeProperties(AbstractBuild build, BaseGradleReleaseAction release, boolean releaseVersion, BuildListener listener) throws IOException, InterruptedException {
        String[] additionalModuleProperties;
        FilePath root = release.getModuleRoot((Map<String, String>)build.getEnvironment((TaskListener)listener));
        debuggingLogger.fine("Root directory is: " + root.getRemote());
        String[] modules = release.getReleaseProperties();
        HashMap<String, String> modulesByName = new HashMap<String, String>();
        for (String module : modules) {
            String version = releaseVersion ? release.getReleaseVersionFor(module) : release.getCurrentVersionFor(module);
            modulesByName.put(module, version);
        }
        for (String property : additionalModuleProperties = release.getNextIntegProperties()) {
            String version = releaseVersion ? release.getReleaseVersionFor(property) : release.getNextVersionFor(property);
            modulesByName.put(property, version);
        }
        debuggingLogger.fine("Changing version of gradle properties");
        FilePath gradlePropertiesFilePath = new FilePath(root, "gradle.properties");
        String next = releaseVersion ? "release" : "development";
        this.log(listener, "Changing gradle.properties at " + gradlePropertiesFilePath.getRemote() + " for " + next + " version");
        this.scmCoordinator.edit(gradlePropertiesFilePath);
        boolean modified = (Boolean)gradlePropertiesFilePath.act((FilePath.FileCallable)new GradlePropertiesTransformer(modulesByName));
        if (!modified && !modulesByName.isEmpty() && releaseVersion) {
            listener.fatalError("Could not modify the defined release properties. The properties are either absent from this build's gradle.properties or already equal in value. Please check the release properties defined in the job configuration.\n");
            throw new Run.RunnerAbortedException();
        }
        return modified;
    }

    private void log(BuildListener listener, String message) {
        listener.getLogger().println("[RELEASE] " + message);
    }
}

