/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.maven;

import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.ModuleName;
import hudson.model.Item;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.PromotionConfig;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.VcsConfig;
import org.jfrog.hudson.release.VersionedModule;
import org.jfrog.hudson.release.maven.MavenReleaseWrapper;
import org.kohsuke.stapler.StaplerRequest;

public abstract class BaseMavenReleaseAction
extends ReleaseAction<MavenModuleSet, MavenReleaseWrapper> {
    private Map<ModuleName, String> releaseVersionPerModule;
    private Map<ModuleName, String> nextVersionPerModule;

    public BaseMavenReleaseAction(MavenModuleSet project) {
        super(project, MavenReleaseWrapper.class);
    }

    public String getDefaultVersioning() {
        return this.defaultVersioning;
    }

    @Override
    public List<String> getRepositoryKeys() throws IOException {
        ArtifactoryRedeployPublisher artifactoryPublisher = this.getPublisher();
        if (artifactoryPublisher != null) {
            return artifactoryPublisher.getArtifactoryServer().getReleaseRepositoryKeysFirst(this.getPublisher(), (Item)this.project);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isArtifactoryPro() {
        return this.getArtifactoryServer().isArtifactoryPro(this.getPublisher(), (Item)this.project);
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        ArtifactoryRedeployPublisher artifactoryPublisher = this.getPublisher();
        if (artifactoryPublisher != null) {
            return artifactoryPublisher.getArtifactoryServer();
        }
        return null;
    }

    @Override
    protected PluginSettings getSelectedStagingPlugin() throws Exception {
        return this.getPublisher().getSelectedStagingPlugin();
    }

    @Override
    protected String getSelectedStagingPluginName() {
        return this.getPublisher().getDeployerDetails().getUserPluginKey();
    }

    @Override
    protected void doPerModuleVersioning(StaplerRequest req) {
        this.releaseVersionPerModule = new HashMap<ModuleName, String>();
        this.nextVersionPerModule = new HashMap<ModuleName, String>();
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            ModuleName moduleName;
            String key = (String)params.nextElement();
            if (key.startsWith("release.")) {
                moduleName = ModuleName.fromString((String)StringUtils.removeStart((String)key, (String)"release."));
                this.releaseVersionPerModule.put(moduleName, req.getParameter(key));
                continue;
            }
            if (!key.startsWith("next.")) continue;
            moduleName = ModuleName.fromString((String)StringUtils.removeStart((String)key, (String)"next."));
            this.nextVersionPerModule.put(moduleName, req.getParameter(key));
        }
    }

    @Override
    protected void doPerModuleVersioning(Map<String, VersionedModule> defaultModules) {
        this.releaseVersionPerModule = new HashMap<ModuleName, String>();
        this.nextVersionPerModule = new HashMap<ModuleName, String>();
        for (Map.Entry<String, VersionedModule> entry : defaultModules.entrySet()) {
            VersionedModule versionedModule = entry.getValue();
            ModuleName module = ModuleName.fromString((String)versionedModule.getModuleName());
            this.releaseVersionPerModule.put(module, versionedModule.getReleaseVersion());
            this.nextVersionPerModule.put(module, versionedModule.getNextDevelopmentVersion());
        }
    }

    @Override
    public String getReleaseVersionFor(Object moduleName) {
        ModuleName mavenModuleName = (ModuleName)moduleName;
        switch (this.versioning) {
            case GLOBAL: {
                return this.releaseVersion;
            }
            case PER_MODULE: {
                return this.releaseVersionPerModule.get(mavenModuleName);
            }
        }
        return null;
    }

    @Override
    public String getNextVersionFor(Object moduleName) {
        ModuleName mavenModuleName = (ModuleName)moduleName;
        switch (this.versioning) {
            case GLOBAL: {
                return this.nextVersion;
            }
            case PER_MODULE: {
                return this.nextVersionPerModule.get(mavenModuleName);
            }
        }
        return null;
    }

    public String getCurrentVersion() {
        return this.getRootModule().getVersion();
    }

    @Override
    protected void prepareBuilderSpecificDefaultVersioning() {
        this.defaultVersioning = ((MavenReleaseWrapper)((Object)this.getWrapper())).getDefaultVersioning();
    }

    @Override
    protected void prepareBuilderSpecificDefaultGlobalModule() {
        if (this.project != null && this.getRootModule() != null) {
            String releaseVersion = this.calculateReleaseVersion(this.getRootModule().getVersion());
            this.defaultGlobalModule = new VersionedModule(null, releaseVersion, this.calculateNextVersion(releaseVersion));
        }
    }

    @Override
    protected void prepareBuilderSpecificDefaultModules() {
        this.defaultModules = new HashMap();
        if (this.project != null) {
            List modules = ((MavenModuleSet)this.project).getDisabledModules(false);
            for (MavenModule mavenModule : modules) {
                String version = mavenModule.getVersion();
                String moduleName = mavenModule.getModuleName().toString();
                this.defaultModules.put(moduleName, new VersionedModule(moduleName, this.calculateReleaseVersion(version), this.calculateNextVersion(version)));
            }
        }
    }

    @Override
    protected void prepareBuilderSpecificDefaultVcsConfig() {
        String defaultReleaseBranch = this.getDefaultReleaseBranch();
        String defaultTagUrl = this.getDefaultTagUrl();
        this.defaultVcsConfig = new VcsConfig(StringUtils.isNotBlank((CharSequence)defaultReleaseBranch) && ((MavenReleaseWrapper)((Object)this.getWrapper())).isUseReleaseBranch(), defaultReleaseBranch, StringUtils.isNotBlank((CharSequence)defaultTagUrl), defaultTagUrl, this.getDefaultTagComment(), this.getDefaultNextDevelCommitMessage());
    }

    @Override
    protected void prepareBuilderSpecificDefaultPromotionConfig() throws IOException {
        this.defaultPromotionConfig = new PromotionConfig(this.getDefaultReleaseStagingRepository(), null);
    }

    private MavenModule getRootModule() {
        return ((MavenModuleSet)this.project).getRootModule();
    }

    private ArtifactoryRedeployPublisher getPublisher() {
        return ActionableHelper.getPublisher(this.project, ArtifactoryRedeployPublisher.class);
    }

    private String getDefaultReleaseBranch() {
        MavenReleaseWrapper wrapper = (MavenReleaseWrapper)((Object)this.getWrapper());
        String releaseBranchPrefix = wrapper.getReleaseBranchPrefix();
        StringBuilder sb = new StringBuilder(StringUtils.trimToEmpty((String)releaseBranchPrefix));
        MavenModule rootModule = this.getRootModule();
        if (rootModule != null) {
            sb.append(rootModule.getModuleName().artifactId).append("-").append(this.getDefaultReleaseVersion());
        }
        return sb.toString();
    }

    private String getDefaultTagUrl() {
        MavenReleaseWrapper wrapper = (MavenReleaseWrapper)((Object)this.getWrapper());
        String baseTagUrl = wrapper.getTagPrefix();
        StringBuilder sb = new StringBuilder(this.getBaseTagUrlAccordingToScm(baseTagUrl));
        MavenModule rootModule = this.getRootModule();
        if (rootModule != null) {
            sb.append(rootModule.getModuleName().artifactId).append("-").append(this.getDefaultReleaseVersion());
        }
        return sb.toString();
    }

    @Override
    public String getTargetRemoteName() {
        return ((MavenReleaseWrapper)((Object)this.getWrapper())).getTargetRemoteName();
    }

    private String getDefaultTagComment() {
        return "[artifactory-release] Release version " + this.getDefaultReleaseVersion();
    }

    private String getDefaultReleaseVersion() {
        if (ReleaseAction.VERSIONING.GLOBAL.name().equals(this.getDefaultVersioning())) {
            return this.getDefaultGlobalReleaseVersion();
        }
        if (!this.defaultModules.isEmpty()) {
            ((VersionedModule)this.defaultModules.values().iterator().next()).getReleaseVersion();
        }
        return "";
    }

    private String getDefaultReleaseStagingRepository() throws IOException {
        String defaultStagingRepo = ((MavenReleaseWrapper)((Object)this.getWrapper())).getDefaultReleaseStagingRepository();
        if (!defaultStagingRepo.isEmpty() && this.getRepositoryKeys().contains(defaultStagingRepo)) {
            return defaultStagingRepo;
        }
        ArtifactoryRedeployPublisher publisher = this.getPublisher();
        if (publisher == null) {
            return null;
        }
        return publisher.getRepositoryKey();
    }
}

