/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import java.io.IOException;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.scm.ScmCoordinator;
import org.jfrog.hudson.release.scm.git.GitCoordinator;
import org.jfrog.hudson.release.scm.perforce.P4Manager;
import org.jfrog.hudson.release.scm.perforce.PerforceCoordinator;
import org.jfrog.hudson.release.scm.svn.SubversionCoordinator;

public abstract class AbstractScmCoordinator
implements ScmCoordinator {
    protected final AbstractBuild build;
    protected final BuildListener listener;
    protected boolean modifiedFilesForReleaseVersion;
    protected boolean modifiedFilesForDevVersion;

    public AbstractScmCoordinator(AbstractBuild build, BuildListener listener) {
        this.build = build;
        this.listener = listener;
    }

    public static ScmCoordinator createScmCoordinator(AbstractBuild build, BuildListener listener, ReleaseAction releaseAction) {
        SCM projectScm = build.getProject().getScm();
        if (AbstractScmCoordinator.isSvn(build.getProject())) {
            return new SubversionCoordinator(build, listener, releaseAction);
        }
        if (AbstractScmCoordinator.isGitScm(build.getProject())) {
            return new GitCoordinator(build, listener, releaseAction);
        }
        if (AbstractScmCoordinator.isP4SCM(build.getProject())) {
            return new PerforceCoordinator(build, listener, releaseAction, new P4Manager(build, (TaskListener)listener));
        }
        throw new UnsupportedOperationException("Scm of type: " + projectScm.getClass().getName() + " is not supported");
    }

    private static boolean isP4SCM(AbstractProject project) {
        SCM projectSCM = project.getScm();
        return projectSCM != null && projectSCM.getClass().getName().equals("org.jenkinsci.plugins.p4.PerforceScm");
    }

    public static boolean isSvn(AbstractProject project) {
        SCM scm = project.getScm();
        if (scm != null) {
            return scm.getClass().getName().equals("hudson.scm.SubversionSCM");
        }
        return false;
    }

    public static boolean isGitScm(AbstractProject project) {
        SCM scm = project.getScm();
        if (scm != null) {
            return scm.getClass().getName().equals("hudson.plugins.git.GitSCM");
        }
        return false;
    }

    protected void log(String message) {
        this.listener.getLogger().println("[RELEASE] " + message);
    }

    @Override
    public void beforeReleaseVersionChange() throws IOException, InterruptedException {
    }

    @Override
    public void afterReleaseVersionChange(boolean modified) throws IOException, InterruptedException {
        this.modifiedFilesForReleaseVersion = modified;
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        this.modifiedFilesForDevVersion = modified;
    }

    @Override
    public void edit(FilePath filePath) throws IOException, InterruptedException {
    }
}

