/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.git;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import jenkins.MasterToSlaveFileCallable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitPushDryRunCallable
extends MasterToSlaveFileCallable<Void> {
    private String username;
    private String password;
    private String targetUri;
    private URI uri;

    public GitPushDryRunCallable(String username, String password, String targetUri, URI uri) throws IOException, InterruptedException {
        this.username = username;
        this.password = password;
        this.targetUri = targetUri;
        this.uri = uri;
    }

    public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        UsernamePasswordCredentialsProvider provider = new UsernamePasswordCredentialsProvider(this.username, this.password);
        Git git = Git.open((File)new File(this.uri));
        try {
            PushCommand pc = ((PushCommand)git.push().setRemote(this.targetUri).setCredentialsProvider((CredentialsProvider)provider)).setDryRun(true).setPushTags();
            pc.call();
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
        finally {
            if (git.getRepository() != null) {
                git.getRepository().close();
            }
        }
        return null;
    }
}

